/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang.WordUtils;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.settings.YamlConfig;

public final class ConfigItems<T extends YamlConfig> {
    private volatile List<T> loadedItems = new ArrayList<T>();
    private final String type;
    private final String folder;
    private final Class<T> prototypeClass;
    private final boolean hasDefaultPrototype;
    private boolean verbose = true;

    public ConfigItems(String type, String folder, Class<T> prototypeClass) {
        this(type, folder, prototypeClass, true);
    }

    public ConfigItems(String type, String folder, Class<T> prototypeClass, boolean hasDefaultPrototype) {
        this.type = type;
        this.folder = folder;
        this.prototypeClass = prototypeClass;
        this.hasDefaultPrototype = hasDefaultPrototype;
    }

    public void loadItems() {
        File[] files;
        this.loadedItems.clear();
        if (!FileUtil.getFile(this.folder).exists()) {
            FileUtil.extractFolderFromJar(this.folder + "/", this.folder);
        }
        for (File file : files = FileUtil.getFiles(this.folder, "yml")) {
            String name = FileUtil.getFileName(file);
            this.loadOrCreateItem(name);
        }
    }

    public T loadOrCreateItem(String name) {
        Valid.checkBoolean(!this.isItemLoaded(name), WordUtils.capitalize((String)this.type) + name + " is already loaded: " + this.getItemNames(), new Object[0]);
        try {
            Constructor<T> constructor;
            boolean nameConstructor = true;
            try {
                constructor = this.prototypeClass.getDeclaredConstructor(String.class);
            }
            catch (Exception e) {
                constructor = this.prototypeClass.getDeclaredConstructor(new Class[0]);
                nameConstructor = false;
            }
            Valid.checkBoolean(Modifier.isPrivate(constructor.getModifiers()), "Your class " + this.prototypeClass + " must have private constructor taking a String or nothing!", new Object[0]);
            constructor.setAccessible(true);
            YamlConfig item = nameConstructor ? (YamlConfig)constructor.newInstance(name) : (YamlConfig)constructor.newInstance(new Object[0]);
            item.loadConfiguration(this.hasDefaultPrototype ? "prototype/" + this.type + ".yml" : YamlConfig.NO_DEFAULT, this.folder + "/" + name + ".yml");
            this.loadedItems.add(item);
            if (this.verbose) {
                Common.log("[+] Loaded " + this.type + " " + item.getName());
            }
            return (T)item;
        }
        catch (Throwable t) {
            Common.throwError(t, "Failed to load " + this.type + " " + name);
            return null;
        }
    }

    public void removeItem(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Valid.checkBoolean(this.isItemLoaded(((YamlConfig)item).getName()), WordUtils.capitalize((String)this.type) + " " + ((YamlConfig)item).getName() + " not loaded. Available: " + this.getItemNames(), new Object[0]);
        ((YamlConfig)item).delete();
        this.loadedItems.remove(item);
    }

    public boolean isItemLoaded(String name) {
        return this.findItem(name) != null;
    }

    public T findItem(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (YamlConfig item : this.loadedItems) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return (T)item;
        }
        return null;
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.loadedItems);
    }

    public List<String> getItemNames() {
        return Common.convert(this.loadedItems, YamlConfig::getName);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

