/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;

class CMIHook {
    CMIHook() {
    }

    boolean isVanished(Player player) {
        CMIUser user = this.getUser(player);
        return user != null && user.isVanished();
    }

    boolean isAfk(Player player) {
        CMIUser user = this.getUser(player);
        return user != null && user.isAfk();
    }

    boolean isMuted(Player player) {
        CMIUser user = this.getUser(player);
        try {
            return user != null && user.getMutedUntil() != 0L && user.getMutedUntil() != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    void setGodMode(Player player, boolean godMode) {
        CMIUser user = this.getUser(player);
        user.setGod(Boolean.valueOf(godMode));
    }

    void setLastTeleportLocation(Player player, Location location) {
        CMIUser user = this.getUser(player);
        try {
            user.getClass().getMethod("setLastTeleportLocation", Location.class).invoke((Object)user, location);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setIgnore(UUID player, UUID who, boolean ignore) {
        CMIUser user = CMI.getInstance().getPlayerManager().getUser(player);
        if (ignore) {
            user.addIgnore(who, true);
        } else {
            user.removeIgnore(who);
        }
    }

    boolean isIgnoring(UUID player, UUID who) {
        try {
            CMIUser user = CMI.getInstance().getPlayerManager().getUser(player);
            return user.isIgnoring(who);
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    String getNick(Player player) {
        CMIUser user = this.getUser(player);
        String nick = user == null ? null : user.getNickName();
        return nick == null || "".equals(nick) ? null : nick;
    }

    String getNameFromNick(String nick) {
        for (CMIUser user : CMI.getInstance().getPlayerManager().getAllUsers().values()) {
            if (user == null || user.getNickName() == null || !Valid.colorlessEquals(user.getNickName().toLowerCase(), nick.toLowerCase())) continue;
            return Common.getOrDefault(user.getName(), nick);
        }
        return nick;
    }

    private CMIUser getUser(Player player) {
        return CMI.getInstance().getPlayerManager().getUser(player);
    }
}

