/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mineacademy.fo.ChatUtil;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.remain.Remain;

public final class BoxedMessage {
    public static ChatColor LINE_COLOR = ChatColor.DARK_GRAY;
    private final Iterable<? extends CommandSender> recipients;
    private final Player sender;
    private final String[] messages;

    public BoxedMessage(String ... messages) {
        this((Iterable<? extends CommandSender>)null, (Player)null, messages);
    }

    private BoxedMessage(Iterable<? extends CommandSender> recipients, Player sender, String[] messages) {
        this.recipients = recipients;
        this.sender = sender;
        this.messages = messages;
    }

    private void launch() {
        Common.runLater(2, () -> {
            boolean tellPrefixState = Common.ADD_TELL_PREFIX;
            Common.ADD_TELL_PREFIX = false;
            this.sendFrame();
            Common.ADD_TELL_PREFIX = tellPrefixState;
        });
    }

    private void sendFrame() {
        this.sendLine();
        this.sendFrameInternals0();
        this.sendLine();
    }

    private void sendFrameInternals0() {
        for (int i = 0; i < this.getTopLines(); ++i) {
            this.send("&r");
        }
        for (String message : this.messages) {
            for (String part : message.split("\n")) {
                this.send(part);
            }
        }
        for (int i = 0; i < this.getBottomLines(); ++i) {
            this.send("&r");
        }
    }

    private int getTopLines() {
        switch (this.length()) {
            case 1: {
                return 2;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private int getBottomLines() {
        switch (this.length()) {
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private void sendLine() {
        this.send(LINE_COLOR + Common.chatLineSmooth());
    }

    private int length() {
        int length = 0;
        for (String message : this.messages) {
            for (String part : message.split("\n")) {
                ++length;
            }
        }
        return length;
    }

    private void send(String message) {
        message = this.centerMessage0(message);
        if (this.recipients == null) {
            this.broadcast0(message);
        } else {
            this.tell0(message);
        }
    }

    private String centerMessage0(String message) {
        if (message.startsWith("<center>")) {
            return ChatUtil.center(message.replaceFirst("\\<center\\>(\\s|)", ""));
        }
        return message;
    }

    private void broadcast0(String message) {
        if (this.sender != null) {
            Common.broadcast(message, (CommandSender)this.sender);
        } else {
            Common.broadcastTo(Remain.getOnlinePlayers(), message);
        }
    }

    private void tell0(String message) {
        if (this.sender != null) {
            message = message.replace("{player}", Common.resolveSenderName((CommandSender)this.sender));
        }
        Common.broadcastTo(this.recipients, message);
    }

    public Replacor find(String ... variables) {
        return new Replacor(variables);
    }

    public String getMessage() {
        return StringUtils.join((Object[])this.messages, (String)"\n");
    }

    public String toString() {
        return "Boxed{" + StringUtils.join((Object[])this.messages, (String)", ") + "}";
    }

    public void broadcast() {
        BoxedMessage.broadcast(null, this.messages);
    }

    public void broadcastAs(Player sender) {
        new BoxedMessage(null, sender, this.messages).launch();
    }

    public void tell(CommandSender recipient) {
        BoxedMessage.tell(null, Arrays.asList(recipient), this.messages);
    }

    public void tell(Iterable<? extends CommandSender> recipients) {
        BoxedMessage.tell(null, recipients, this.messages);
    }

    public void tellAs(CommandSender receiver, Player sender) {
        BoxedMessage.tell(sender, Arrays.asList(receiver), this.messages);
    }

    public void tellAs(Iterable<? extends CommandSender> receivers, Player sender) {
        new BoxedMessage(receivers, sender, this.messages).launch();
    }

    public static void broadcast(String ... messages) {
        BoxedMessage.broadcast(null, messages);
    }

    public static void broadcast(Player sender, String ... messages) {
        new BoxedMessage(null, sender, messages).launch();
    }

    public static void tell(CommandSender recipient, String ... messages) {
        BoxedMessage.tell(null, Arrays.asList(recipient), messages);
    }

    public static void tell(Iterable<? extends CommandSender> recipients, String ... messages) {
        BoxedMessage.tell(null, recipients, messages);
    }

    public static void tell(Player sender, CommandSender receiver, String ... messages) {
        BoxedMessage.tell(sender, Arrays.asList(receiver), messages);
    }

    public static void tell(Player sender, Iterable<? extends CommandSender> receivers, String ... messages) {
        new BoxedMessage(receivers, sender, messages).launch();
    }

    public class Replacor {
        private final String[] variables;

        public final BoxedMessage replace(Object ... replacements) {
            String message = StringUtils.join((Object[])BoxedMessage.this.messages, (String)"%delimiter%");
            for (int i = 0; i < this.variables.length; ++i) {
                String find = this.variables[i];
                if (!find.startsWith("{")) {
                    find = "{" + find;
                }
                if (!find.endsWith("}")) {
                    find = find + "}";
                }
                Object rep = i < replacements.length ? replacements[i] : null;
                message = message.replace(find, rep != null ? Objects.toString(rep) : "");
            }
            String[] copy = message.split("%delimiter%");
            return new BoxedMessage(BoxedMessage.this.recipients, BoxedMessage.this.sender, copy);
        }

        public Replacor(String[] variables) {
            this.variables = variables;
        }
    }
}

