/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.tool;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.menu.tool.Tool;

public final class ToolRegistry {
    private static final Collection<Tool> tools = new ConcurrentLinkedQueue<Tool>();

    static synchronized void register(Tool tool) {
        Valid.checkBoolean(!ToolRegistry.isRegistered(tool), "Tool with itemstack " + tool.getItem() + " already registered", new Object[0]);
        tools.add(tool);
    }

    static synchronized boolean isRegistered(Tool tool) {
        return ToolRegistry.getTool(tool.getItem()) != null;
    }

    public static Tool getTool(ItemStack item) {
        for (Tool t : tools) {
            if (!t.isTool(item)) continue;
            return t;
        }
        return null;
    }

    public static Tool[] getTools() {
        return tools.toArray(new Tool[tools.size()]);
    }
}

