/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.model.SimpleEnchant;
import org.mineacademy.fo.model.SimpleEnchantment;
import org.mineacademy.fo.model.Tuple;
import org.mineacademy.fo.remain.CompColor;
import org.mineacademy.fo.remain.CompItemFlag;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.CompMetadata;
import org.mineacademy.fo.remain.CompMonsterEgg;
import org.mineacademy.fo.remain.CompProperty;

public final class ItemCreator {
    private final ItemStack item;
    private final CompMaterial material;
    private final int amount;
    private final int damage;
    private final String name;
    private final List<String> lores;
    private final List<SimpleEnchant> enchants;
    private List<CompItemFlag> flags;
    private Boolean unbreakable;
    private final CompColor color;
    private boolean hideTags;
    private final boolean glow;
    private final String skullOwner;
    private final List<Tuple<String, String>> tags;
    private final ItemMeta meta;

    public void give(Player player) {
        player.getInventory().addItem(new ItemStack[]{this.makeSurvival()});
    }

    public Button.DummyButton makeButton() {
        return Button.makeDummy(this);
    }

    public ItemStack makeMenuTool() {
        this.unbreakable = true;
        this.hideTags = true;
        return this.make();
    }

    public ItemStack makeSurvival() {
        this.hideTags = false;
        return this.make();
    }

    public ItemCreator removeEnchants() {
        if (this.item != null) {
            for (Enchantment enchant : this.item.getEnchantments().keySet()) {
                this.item.removeEnchantment(enchant);
            }
        }
        return this;
    }

    public ItemStack make() {
        ItemMeta itemMeta;
        ItemStack is;
        block46: {
            Valid.checkBoolean(this.material != null || this.item != null, "Material or item must be set!", new Object[0]);
            is = this.item != null ? this.item.clone() : new ItemStack(this.material.getMaterial(), this.amount);
            ItemMeta itemMeta2 = itemMeta = this.meta != null ? this.meta.clone() : is.getItemMeta();
            if (CompMaterial.isAir(is.getType())) {
                return is;
            }
            if (this.material != null) {
                is.setType(this.material.getMaterial());
            }
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_12) && this.color != null && !is.getType().toString().contains("LEATHER")) {
                String dye = this.color.getDye().toString();
                List<String> list = Arrays.asList("BANNER", "BED", "CARPET", "CONCRETE", "GLAZED_TERRACOTTA", "SHULKER_BOX", "STAINED_GLASS", "STAINED_GLASS_PANE", "TERRACOTTA", "WALL_BANNER", "WOOL");
                for (String colorable : list) {
                    String suffix = "_" + colorable;
                    if (!is.getType().toString().endsWith(suffix)) continue;
                    is.setType(Material.valueOf((String)(dye + suffix)));
                    break block46;
                }
                if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
                    is.setType(Material.valueOf((String)(dye + "_WOOL")));
                } else if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_8)) {
                    ItemCreator.applyColors0(this.color, this.material, is);
                }
            } else {
                ItemCreator.applyColors0(this.color, this.material, is);
            }
        }
        if (is.getType().toString().endsWith("SPAWN_EGG")) {
            Object entity = null;
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                CompMonsterEgg.acceptUnsafeEggs = true;
                EntityType entityType = CompMonsterEgg.getEntity(is);
                CompMonsterEgg.acceptUnsafeEggs = false;
                if (entityType != null && entityType != EntityType.UNKNOWN) {
                    entity = entityType;
                }
            }
            if (entity == null) {
                String string = is.getType().toString();
                String entityRaw = string.replace("_SPAWN_EGG", "");
                if ("MOOSHROOM".equals(entityRaw)) {
                    entityRaw = "MUSHROOM_COW";
                } else if ("ZOMBIE_PIGMAN".equals(entityRaw)) {
                    entityRaw = "PIG_ZOMBIE";
                }
                try {
                    entity = EntityType.valueOf((String)entityRaw);
                }
                catch (Throwable t) {
                    Common.log("The following item could not be transformed into " + entityRaw + " egg, item: " + is);
                }
            }
            if (entity != null) {
                is = CompMonsterEgg.setEntity(is, entity);
            }
        }
        this.flags = new ArrayList<CompItemFlag>(Common.getOrDefault(this.flags, new ArrayList()));
        if (this.damage != -1) {
            try {
                ReflectionUtil.invoke("setDurability", (Object)is, (short)this.damage);
            }
            catch (Throwable entity) {
                // empty catch block
            }
            try {
                if (itemMeta instanceof Damageable) {
                    ((Damageable)itemMeta).setDamage(this.damage);
                }
            }
            catch (Throwable entity) {
                // empty catch block
            }
        }
        if (this.color != null && is.getType().toString().contains("LEATHER")) {
            ((LeatherArmorMeta)itemMeta).setColor(this.color.getDye().getColor());
        }
        if (this.skullOwner != null && itemMeta instanceof SkullMeta) {
            ((SkullMeta)itemMeta).setOwner(this.skullOwner);
        }
        if (this.glow) {
            itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            this.flags.add(CompItemFlag.HIDE_ENCHANTS);
        }
        if (this.enchants != null) {
            for (SimpleEnchant simpleEnchant : this.enchants) {
                if (itemMeta instanceof EnchantmentStorageMeta) {
                    ((EnchantmentStorageMeta)itemMeta).addStoredEnchant(simpleEnchant.getEnchant(), simpleEnchant.getLevel(), true);
                    continue;
                }
                itemMeta.addEnchant(simpleEnchant.getEnchant(), simpleEnchant.getLevel(), true);
            }
        }
        if (this.name != null && !"".equals(this.name)) {
            itemMeta.setDisplayName(Common.colorize("&r" + this.name));
        }
        if (this.lores != null && !this.lores.isEmpty()) {
            ArrayList<String> coloredLores = new ArrayList<String>();
            for (String lore : this.lores) {
                coloredLores.add(Common.colorize("&7" + lore));
            }
            itemMeta.setLore(coloredLores);
        }
        if (this.unbreakable != null) {
            this.flags.add(CompItemFlag.HIDE_ATTRIBUTES);
            this.flags.add(CompItemFlag.HIDE_UNBREAKABLE);
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_12)) {
                try {
                    Object spigot = itemMeta.getClass().getMethod("spigot", new Class[0]).invoke((Object)itemMeta, new Object[0]);
                    spigot.getClass().getMethod("setUnbreakable", Boolean.TYPE).invoke(spigot, true);
                }
                catch (Throwable spigot) {}
            } else {
                CompProperty.UNBREAKABLE.apply(itemMeta, true);
            }
        }
        if (this.hideTags) {
            for (CompItemFlag f : CompItemFlag.values()) {
                if (this.flags.contains((Object)f)) continue;
                this.flags.add(f);
            }
        }
        for (CompItemFlag compItemFlag : this.flags) {
            try {
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)compItemFlag.toString())});
            }
            catch (Throwable lore) {}
        }
        is.setItemMeta(itemMeta);
        ItemStack enchantedIs = SimpleEnchantment.addEnchantmentLores(is);
        if (enchantedIs != null) {
            is = enchantedIs;
        }
        if (this.tags != null) {
            for (Tuple<String, String> tag : this.tags) {
                is = CompMetadata.setMetadata(is, tag.getKey(), tag.getValue());
            }
        }
        return is;
    }

    private static void applyColors0(CompColor color, CompMaterial material, ItemStack is) {
        int dataValue;
        int n = dataValue = material != null ? material.getData() : (int)is.getData().getData();
        if (!is.getType().toString().contains("LEATHER") && color != null) {
            dataValue = color.getDye().getWoolData();
        }
        if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_8) && CompMaterial.isMonsterEgg(is.getType())) {
            dataValue = 0;
        }
        is.setData(new MaterialData(is.getType(), (byte)dataValue));
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
            is.setDurability((short)dataValue);
        }
    }

    public static ItemCreatorBuilder of(CompMaterial material, String name, @NonNull Collection<String> lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return ItemCreator.of(material, name, lore.toArray(new String[0]));
    }

    public static ItemCreatorBuilder of(String material, String name, @NonNull Collection<String> lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return ItemCreator.of(CompMaterial.valueOf(material), name, lore.toArray(new String[0]));
    }

    public static ItemCreatorBuilder of(CompMaterial material, String name, String ... lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return ItemCreator.builder().material(material).name("&r" + name).lores(Arrays.asList(lore)).hideTags(true);
    }

    public static ItemCreatorBuilder of(String material, String name, String ... lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        return ItemCreator.builder().material(CompMaterial.valueOf(material)).name("&r" + name).lores(Arrays.asList(lore)).hideTags(true);
    }

    public static ItemCreatorBuilder ofWool(CompColor color) {
        return ItemCreator.of(CompMaterial.makeWool(color, 1)).color(color);
    }

    public static ItemCreatorBuilder of(ItemStack item) {
        ItemCreatorBuilder builder = ItemCreator.builder();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getLore() != null) {
            builder.lores(meta.getLore());
        }
        return builder.item(item);
    }

    public static ItemCreatorBuilder of(CompMaterial mat) {
        Valid.checkNotNull((Object)mat, "Material cannot be null!");
        return ItemCreator.builder().material(mat);
    }

    private static int $default$amount() {
        return 1;
    }

    private static int $default$damage() {
        return -1;
    }

    private static boolean $default$hideTags() {
        return false;
    }

    ItemCreator(ItemStack item, CompMaterial material, int amount, int damage, String name, List<String> lores, List<SimpleEnchant> enchants, List<CompItemFlag> flags, Boolean unbreakable, CompColor color, boolean hideTags, boolean glow, String skullOwner, List<Tuple<String, String>> tags, ItemMeta meta) {
        this.item = item;
        this.material = material;
        this.amount = amount;
        this.damage = damage;
        this.name = name;
        this.lores = lores;
        this.enchants = enchants;
        this.flags = flags;
        this.unbreakable = unbreakable;
        this.color = color;
        this.hideTags = hideTags;
        this.glow = glow;
        this.skullOwner = skullOwner;
        this.tags = tags;
        this.meta = meta;
    }

    public static ItemCreatorBuilder builder() {
        return new ItemCreatorBuilder();
    }

    public static class ItemCreatorBuilder {
        private ItemStack item;
        private CompMaterial material;
        private boolean amount$set;
        private int amount$value;
        private boolean damage$set;
        private int damage$value;
        private String name;
        private ArrayList<String> lores;
        private ArrayList<SimpleEnchant> enchants;
        private ArrayList<CompItemFlag> flags;
        private Boolean unbreakable;
        private CompColor color;
        private boolean hideTags$set;
        private boolean hideTags$value;
        private boolean glow;
        private String skullOwner;
        private ArrayList<Tuple<String, String>> tags;
        private ItemMeta meta;

        ItemCreatorBuilder() {
        }

        public ItemCreatorBuilder item(ItemStack item) {
            this.item = item;
            return this;
        }

        public ItemCreatorBuilder material(CompMaterial material) {
            this.material = material;
            return this;
        }

        public ItemCreatorBuilder amount(int amount) {
            this.amount$value = amount;
            this.amount$set = true;
            return this;
        }

        public ItemCreatorBuilder damage(int damage) {
            this.damage$value = damage;
            this.damage$set = true;
            return this;
        }

        public ItemCreatorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ItemCreatorBuilder lore(String lore) {
            if (this.lores == null) {
                this.lores = new ArrayList();
            }
            this.lores.add(lore);
            return this;
        }

        public ItemCreatorBuilder lores(Collection<? extends String> lores) {
            if (lores == null) {
                throw new NullPointerException("lores cannot be null");
            }
            if (this.lores == null) {
                this.lores = new ArrayList();
            }
            this.lores.addAll(lores);
            return this;
        }

        public ItemCreatorBuilder clearLores() {
            if (this.lores != null) {
                this.lores.clear();
            }
            return this;
        }

        public ItemCreatorBuilder enchant(SimpleEnchant enchant) {
            if (this.enchants == null) {
                this.enchants = new ArrayList();
            }
            this.enchants.add(enchant);
            return this;
        }

        public ItemCreatorBuilder enchants(Collection<? extends SimpleEnchant> enchants) {
            if (enchants == null) {
                throw new NullPointerException("enchants cannot be null");
            }
            if (this.enchants == null) {
                this.enchants = new ArrayList();
            }
            this.enchants.addAll(enchants);
            return this;
        }

        public ItemCreatorBuilder clearEnchants() {
            if (this.enchants != null) {
                this.enchants.clear();
            }
            return this;
        }

        public ItemCreatorBuilder flag(CompItemFlag flag) {
            if (this.flags == null) {
                this.flags = new ArrayList();
            }
            this.flags.add(flag);
            return this;
        }

        public ItemCreatorBuilder flags(Collection<? extends CompItemFlag> flags) {
            if (flags == null) {
                throw new NullPointerException("flags cannot be null");
            }
            if (this.flags == null) {
                this.flags = new ArrayList();
            }
            this.flags.addAll(flags);
            return this;
        }

        public ItemCreatorBuilder clearFlags() {
            if (this.flags != null) {
                this.flags.clear();
            }
            return this;
        }

        public ItemCreatorBuilder unbreakable(Boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        public ItemCreatorBuilder color(CompColor color) {
            this.color = color;
            return this;
        }

        public ItemCreatorBuilder hideTags(boolean hideTags) {
            this.hideTags$value = hideTags;
            this.hideTags$set = true;
            return this;
        }

        public ItemCreatorBuilder glow(boolean glow) {
            this.glow = glow;
            return this;
        }

        public ItemCreatorBuilder skullOwner(String skullOwner) {
            this.skullOwner = skullOwner;
            return this;
        }

        public ItemCreatorBuilder tag(Tuple<String, String> tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public ItemCreatorBuilder tags(Collection<? extends Tuple<String, String>> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public ItemCreatorBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public ItemCreatorBuilder meta(ItemMeta meta) {
            this.meta = meta;
            return this;
        }

        public ItemCreator build() {
            List<Tuple<String, String>> tags;
            List<CompItemFlag> flags;
            List<SimpleEnchant> enchants;
            List<String> lores;
            switch (this.lores == null ? 0 : this.lores.size()) {
                case 0: {
                    lores = Collections.emptyList();
                    break;
                }
                case 1: {
                    lores = Collections.singletonList(this.lores.get(0));
                    break;
                }
                default: {
                    lores = Collections.unmodifiableList(new ArrayList<String>(this.lores));
                }
            }
            switch (this.enchants == null ? 0 : this.enchants.size()) {
                case 0: {
                    enchants = Collections.emptyList();
                    break;
                }
                case 1: {
                    enchants = Collections.singletonList(this.enchants.get(0));
                    break;
                }
                default: {
                    enchants = Collections.unmodifiableList(new ArrayList<SimpleEnchant>(this.enchants));
                }
            }
            switch (this.flags == null ? 0 : this.flags.size()) {
                case 0: {
                    flags = Collections.emptyList();
                    break;
                }
                case 1: {
                    flags = Collections.singletonList(this.flags.get(0));
                    break;
                }
                default: {
                    flags = Collections.unmodifiableList(new ArrayList<CompItemFlag>(this.flags));
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<Tuple<String, String>>(this.tags));
                }
            }
            int amount$value = this.amount$value;
            if (!this.amount$set) {
                amount$value = ItemCreator.$default$amount();
            }
            int damage$value = this.damage$value;
            if (!this.damage$set) {
                damage$value = ItemCreator.$default$damage();
            }
            boolean hideTags$value = this.hideTags$value;
            if (!this.hideTags$set) {
                hideTags$value = ItemCreator.$default$hideTags();
            }
            return new ItemCreator(this.item, this.material, amount$value, damage$value, this.name, lores, enchants, flags, this.unbreakable, this.color, hideTags$value, this.glow, this.skullOwner, tags, this.meta);
        }

        public String toString() {
            return "ItemCreator.ItemCreatorBuilder(item=" + this.item + ", material=" + (Object)((Object)this.material) + ", amount$value=" + this.amount$value + ", damage$value=" + this.damage$value + ", name=" + this.name + ", lores=" + this.lores + ", enchants=" + this.enchants + ", flags=" + this.flags + ", unbreakable=" + this.unbreakable + ", color=" + (Object)((Object)this.color) + ", hideTags$value=" + this.hideTags$value + ", glow=" + this.glow + ", skullOwner=" + this.skullOwner + ", tags=" + this.tags + ", meta=" + this.meta + ")";
        }
    }
}

