/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.model;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.remain.CompMaterial;

public final class InventoryDrawer {
    private final int size;
    private String title;
    private final ItemStack[] content;

    private InventoryDrawer(int size, String title) {
        this.size = size;
        this.title = title;
        this.content = new ItemStack[size];
    }

    public void pushItem(ItemStack item) {
        boolean added = false;
        for (int i = 0; i < this.content.length; ++i) {
            ItemStack currentItem = this.content[i];
            if (currentItem != null) continue;
            this.content[i] = item;
            added = true;
            break;
        }
        if (!added) {
            this.content[this.size - 1] = item;
        }
    }

    public boolean isSet(int slot) {
        return this.getItem(slot) != null;
    }

    public ItemStack getItem(int slot) {
        return slot < this.content.length ? this.content[slot] : null;
    }

    public void setItem(int slot, ItemStack item) {
        this.content[slot] = item;
    }

    public void setContent(ItemStack[] newContent) {
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = i < newContent.length ? newContent[i] : new ItemStack(CompMaterial.AIR.getMaterial());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void display(Player player) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)Common.colorize("&0" + this.title));
        inv.setContents(this.content);
        if (player.getOpenInventory() != null) {
            player.closeInventory();
        }
        player.openInventory(inv);
    }

    public static InventoryDrawer of(int size, String title) {
        return new InventoryDrawer(size, title);
    }

    public int getSize() {
        return this.size;
    }
}

