/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.button;

import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.button.ButtonReturnBack;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompColor;
import org.mineacademy.fo.remain.CompItemFlag;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.settings.SimpleLocalization;

public class ButtonRemove
extends Button {
    private final Menu parentMenu;
    private final String toRemoveType;
    private final String toRemoveName;
    private final ButtonRemoveAction removeAction;

    @Override
    public ItemStack getItem() {
        return ItemCreator.of(CompMaterial.LAVA_BUCKET).name("&4&lRemove " + this.toRemoveName).lores(Arrays.asList("&r", "&7The selected " + this.toRemoveType + " will", "&7be removed permanently.")).flag(CompItemFlag.HIDE_ATTRIBUTES).build().make();
    }

    public ItemStack getRemoveConfirmItem() {
        return ItemCreator.ofWool(CompColor.RED).name("&6&lRemove " + this.toRemoveName).lores(Arrays.asList("&r", "&7Confirm that this " + this.toRemoveType + " will", "&7be removed permanently.", "&cCannot be undone.")).flag(CompItemFlag.HIDE_ATTRIBUTES).build().make();
    }

    public String getMenuTitle() {
        return "&0Confirm removal";
    }

    @Override
    public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
        new MenuDialogRemove(this.parentMenu, new RemoveConfirmButton()).displayTo(pl);
    }

    public ButtonRemove(Menu parentMenu, String toRemoveType, String toRemoveName, ButtonRemoveAction removeAction) {
        this.parentMenu = parentMenu;
        this.toRemoveType = toRemoveType;
        this.toRemoveName = toRemoveName;
        this.removeAction = removeAction;
    }

    final class MenuDialogRemove
    extends Menu {
        private final Button confirmButton;
        private final Button returnButton;

        public MenuDialogRemove(Menu parentMenu, RemoveConfirmButton confirmButton) {
            super(parentMenu);
            this.confirmButton = confirmButton;
            this.returnButton = new ButtonReturnBack(parentMenu);
            this.setSize(27);
            this.setTitle(ButtonRemove.this.getMenuTitle());
        }

        @Override
        public ItemStack getItemAt(int slot) {
            if (slot == 12) {
                return this.confirmButton.getItem();
            }
            if (slot == 14) {
                return this.returnButton.getItem();
            }
            return null;
        }

        @Override
        protected boolean addReturnButton() {
            return false;
        }

        @Override
        protected String[] getInfo() {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ButtonRemoveAction {
        public void remove(String var1);
    }

    final class RemoveConfirmButton
    extends Button {
        @Override
        public ItemStack getItem() {
            return ButtonRemove.this.getRemoveConfirmItem();
        }

        @Override
        public void onClickedInMenu(Player player, Menu menu, ClickType click) {
            player.closeInventory();
            ButtonRemove.this.removeAction.remove(ButtonRemove.this.toRemoveName);
            Common.tell((CommandSender)player, SimpleLocalization.Menu.ITEM_DELETED.replace("{item}", (!ButtonRemove.this.toRemoveType.isEmpty() ? ButtonRemove.this.toRemoveType + " " : "") + ButtonRemove.this.toRemoveName));
        }

        private RemoveConfirmButton() {
        }
    }
}

