/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.button;

import java.util.concurrent.Callable;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompMaterial;

public final class ButtonMenu
extends Button {
    private final Callable<Menu> menuLateBind;
    private final Menu menuToOpen;
    private final ItemStack item;
    private final boolean newInstance;

    public ButtonMenu(Class<? extends Menu> menuClass, CompMaterial material, String name, String ... lore) {
        this(null, () -> (Menu)ReflectionUtil.instantiate(menuClass), ItemCreator.of(material, name, lore).hideTags(true).build().make(), false);
    }

    public ButtonMenu(Callable<Menu> menuLateBind, ItemCreator.ItemCreatorBuilder item) {
        this(null, menuLateBind, item.hideTags(true).build().make(), false);
    }

    public ButtonMenu(Callable<Menu> menuLateBind, ItemStack item) {
        this(null, menuLateBind, item, false);
    }

    public ButtonMenu(Menu menu, CompMaterial material, String name, String ... lore) {
        this(menu, ItemCreator.of(material, name, lore));
    }

    public ButtonMenu(Menu menu, ItemCreator.ItemCreatorBuilder item) {
        this(menu, null, item.hideTags(true).build().make(), false);
    }

    public ButtonMenu(Menu menu, ItemStack item) {
        this(menu, null, item, false);
    }

    public ButtonMenu(Menu menu, ItemStack item, boolean newInstance) {
        this(menu, null, item, newInstance);
    }

    private ButtonMenu(Menu menuToOpen, Callable<Menu> menuLateBind, ItemStack item, boolean newInstance) {
        this.menuToOpen = menuToOpen;
        this.menuLateBind = menuLateBind;
        this.item = item;
        this.newInstance = newInstance;
    }

    @Override
    public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
        if (this.menuLateBind != null) {
            Menu menuToOpen = null;
            try {
                menuToOpen = this.menuLateBind.call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            if (this.newInstance) {
                menuToOpen = menuToOpen.newInstance();
            }
            menuToOpen.displayTo(pl);
        } else {
            Valid.checkNotNull(this.menuToOpen, "Report / ButtonTrigger requires either 'late bind menu' or normal menu to be set!");
            if (this.newInstance) {
                this.menuToOpen.newInstance().displayTo(pl);
            } else {
                this.menuToOpen.displayTo(pl);
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }
}

