/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.button;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.conversation.SimpleConversation;
import org.mineacademy.fo.conversation.SimplePrompt;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompMaterial;

public final class ButtonConversation
extends Button {
    private final SimpleConversation conversation;
    private final SimplePrompt prompt;
    private final ItemStack item;

    public ButtonConversation(SimpleConversation convo, CompMaterial material, String title, String ... lore) {
        this(convo, ItemCreator.of(material, title, lore));
    }

    public ButtonConversation(SimpleConversation convo, ItemCreator.ItemCreatorBuilder item) {
        this(convo, null, item.hideTags(true).build().make());
    }

    public ButtonConversation(SimpleConversation convo, ItemCreator item) {
        this(convo, null, item.make());
    }

    public ButtonConversation(SimplePrompt prompt, CompMaterial material, String title, String ... lore) {
        this(prompt, ItemCreator.of(material, title, lore));
    }

    public ButtonConversation(SimplePrompt prompt, ItemCreator item) {
        this(null, prompt, item.make());
    }

    public ButtonConversation(SimplePrompt prompt, ItemCreator.ItemCreatorBuilder item) {
        this(null, prompt, item.hideTags(true).build().make());
    }

    private ButtonConversation(SimpleConversation conversation, SimplePrompt prompt, ItemStack item) {
        this.conversation = conversation;
        this.prompt = prompt;
        this.item = item;
    }

    @Override
    public void onClickedInMenu(Player player, Menu menu, ClickType click) {
        Valid.checkBoolean(this.conversation != null || this.prompt != null, "Conversation and prompt cannot be null!", new Object[0]);
        if (this.conversation != null) {
            this.conversation.setMenuToReturnTo(menu);
            this.conversation.start(player);
        } else {
            this.prompt.show(player);
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }
}

