/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu.button;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.conversation.SimpleDecimalPrompt;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompMaterial;

public abstract class Button {
    private static CompMaterial infoButtonMaterial = CompMaterial.NETHER_STAR;
    private static String infoButtonTitle = "&fMenu Information";

    public abstract void onClickedInMenu(Player var1, Menu var2, ClickType var3);

    public abstract ItemStack getItem();

    public static final DummyButton makeInfo(String ... description) {
        ArrayList<String> lores = new ArrayList<String>();
        lores.add(" ");
        for (String line : description) {
            lores.add("&7" + line);
        }
        return Button.makeDummy(ItemCreator.of(infoButtonMaterial).name(infoButtonTitle).hideTags(true).lores(lores));
    }

    public static final DummyButton makeEmpty() {
        return Button.makeDummy(ItemCreator.of(CompMaterial.AIR));
    }

    public static final DummyButton makeDummy(ItemCreator.ItemCreatorBuilder builder) {
        return Button.makeDummy(builder.build());
    }

    public static final DummyButton makeDummy(ItemCreator creator) {
        return new DummyButton(creator.makeMenuTool());
    }

    public static final Button makeSimple(final CompMaterial icon, final String title, final String label, final Consumer<Player> onClickFunction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(icon, title, "", label).build().makeMenuTool();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                onClickFunction.accept(player);
            }
        };
    }

    public static final Button makeSimple(final CompMaterial icon, final String title, final String label, final BiConsumer<Player, ClickType> onClickFunction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(icon, title, "", label).build().makeMenuTool();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                onClickFunction.accept(player, click);
            }
        };
    }

    public static Button makeDecimalPrompt(final ItemCreator.ItemCreatorBuilder builder, final String question, final Consumer<Double> successAction) {
        return new Button(){

            @Override
            public ItemStack getItem() {
                return builder.build().make();
            }

            @Override
            public void onClickedInMenu(Player player, Menu menu, ClickType click) {
                SimpleDecimalPrompt.show(player, question, successAction);
            }
        };
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.getItem().getType() + "}";
    }

    public static void setInfoButtonMaterial(CompMaterial infoButtonMaterial) {
        Button.infoButtonMaterial = infoButtonMaterial;
    }

    public static void setInfoButtonTitle(String infoButtonTitle) {
        Button.infoButtonTitle = infoButtonTitle;
    }

    public static final class DummyButton
    extends Button {
        private final ItemStack item;

        @Override
        public void onClickedInMenu(Player player, Menu menu, ClickType click) {
        }

        private DummyButton(ItemStack item) {
            this.item = item;
        }

        @Override
        public ItemStack getItem() {
            return this.item;
        }
    }
}

