/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu;

import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.menu.tool.Tool;
import org.mineacademy.fo.model.SimpleEnchant;
import org.mineacademy.fo.remain.CompItemFlag;

final class ToggleableTool {
    private final ItemStack item;
    private boolean playerHasTool = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ToggleableTool(Object unparsed) {
        if (unparsed != null) {
            if (unparsed instanceof ItemStack) {
                this.item = (ItemStack)unparsed;
                return;
            } else if (unparsed instanceof Tool) {
                this.item = ((Tool)unparsed).getItem();
                return;
            } else {
                if (!(unparsed instanceof Number) || ((Number)unparsed).intValue() != 0) throw new FoException("Unknown tool: " + unparsed + " (we only accept ItemStack, Tool's instance or 0 for air)");
                this.item = new ItemStack(Material.AIR);
            }
            return;
        } else {
            this.item = new ItemStack(Material.AIR);
        }
    }

    ItemStack get(Player player) {
        this.update(player);
        return this.playerHasTool ? this.getToolWhenHas() : this.getToolWhenHasnt();
    }

    private void update(Player pl) {
        this.playerHasTool = pl.getOpenInventory().getBottomInventory().containsAtLeast(this.item, 1);
    }

    private ItemStack getToolWhenHas() {
        return ItemCreator.of(this.item).enchant(new SimpleEnchant(Enchantment.ARROW_INFINITE, 1)).flag(CompItemFlag.HIDE_ENCHANTS).lores(Arrays.asList("", "&cYou already have this item.", "&7Click to take it away.")).build().make();
    }

    private ItemStack getToolWhenHasnt() {
        return this.item;
    }

    void giveOrTake(Player player) {
        PlayerInventory inv = player.getInventory();
        this.playerHasTool = !this.playerHasTool;
        if (this.playerHasTool) {
            inv.addItem(new ItemStack[]{this.item});
        } else {
            inv.removeItem(new ItemStack[]{this.item});
        }
    }

    boolean equals(ItemStack item) {
        return this.getToolWhenHas().isSimilar(item) || this.getToolWhenHasnt().isSimilar(item);
    }

    public String toString() {
        return "Toggleable{" + this.item.getType() + "}";
    }
}

