/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.menu.model.MenuQuantity;
import org.mineacademy.fo.remain.CompMaterial;

public interface MenuQuantitable {
    public MenuQuantity getQuantity();

    public void setQuantity(MenuQuantity var1);

    default public int getNextQuantity(ClickType clickType) {
        return clickType == ClickType.LEFT ? -this.getQuantity().getAmount() : this.getQuantity().getAmount();
    }

    default public Button getEditQuantityButton(final Menu menu) {
        return new Button(){

            @Override
            public final void onClickedInMenu(Player pl, Menu clickedMenu, ClickType click) {
                MenuQuantitable.this.setQuantity(click == ClickType.LEFT ? MenuQuantitable.this.getQuantity().previous() : MenuQuantitable.this.getQuantity().next());
                menu.redraw();
                menu.animateTitle("&9Editing quantity set to " + MenuQuantitable.this.getQuantity().getAmount());
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CompMaterial.STRING, "Edit Quantity: &7" + MenuQuantitable.this.getQuantity().getAmount(), "", "&8< &7Left click to decrease", "&8> &7Right click to increase").build().make();
            }
        };
    }
}

