/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MathUtil;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.model.InventoryDrawer;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.remain.CompMaterial;

public abstract class MenuPagged<T>
extends Menu {
    private final Map<Integer, List<T>> pages;
    private int currentPage = 1;
    protected Button nextButton;
    protected Button prevButton;
    protected int nextPageSlot;
    protected int previousPageSlot;

    protected MenuPagged(Iterable<T> pages) {
        this(null, pages);
    }

    protected MenuPagged(Menu parent, Iterable<T> pages) {
        this(null, parent, pages, false);
    }

    protected MenuPagged(Menu parent, Iterable<T> pages, boolean returnMakesNewInstance) {
        this(null, parent, pages, returnMakesNewInstance);
    }

    @Deprecated
    protected MenuPagged(int pageSize, Iterable<T> pages) {
        this(pageSize, null, pages);
    }

    @Deprecated
    protected MenuPagged(int pageSize, Menu parent, Iterable<T> pages) {
        this(pageSize, parent, pages, false);
    }

    @Deprecated
    protected MenuPagged(int pageSize, Menu parent, Iterable<T> pages, boolean returnMakesNewInstance) {
        this((Integer)pageSize, parent, pages, returnMakesNewInstance);
    }

    private MenuPagged(Integer pageSize, Menu parent, Iterable<T> pages, boolean returnMakesNewInstance) {
        super(parent, returnMakesNewInstance);
        int items = this.getItemAmount(pages);
        int autoPageSize = pageSize != null ? pageSize : (items <= 9 ? 9 : (items <= 18 ? 18 : (items <= 27 ? 27 : (items <= 36 ? 36 : 45))));
        this.currentPage = 1;
        this.pages = this.fillPages(autoPageSize, pages);
        this.setSize(9 + autoPageSize);
        this.nextPageSlot = this.getSize() - 4;
        this.previousPageSlot = this.getSize() - 6;
        this.setButtons();
    }

    private Map<Integer, List<T>> fillPages(int cellSize, Iterable<T> items) {
        List<T> allItems = Common.toList(items);
        HashMap<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
        int pageCount = allItems.size() == cellSize ? 0 : allItems.size() / cellSize;
        for (int i = 0; i <= pageCount; ++i) {
            ArrayList<T> pageItems = new ArrayList<T>();
            int down = cellSize * i;
            int up = down + cellSize;
            for (int valueIndex = down; valueIndex < up && valueIndex < allItems.size(); ++valueIndex) {
                T page = allItems.get(valueIndex);
                pageItems.add(page);
            }
            pages.put(i, pageItems);
        }
        return pages;
    }

    private int getItemAmount(Iterable<T> pages) {
        int amount = 0;
        for (T t : pages) {
            ++amount;
        }
        return amount;
    }

    private void setButtons() {
        boolean hasPages = this.pages.size() > 1;
        this.prevButton = hasPages ? new Button(){
            final boolean canGo;
            {
                this.canGo = MenuPagged.this.currentPage > 1;
            }

            @Override
            public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
                if (this.canGo) {
                    MenuPagged.this.currentPage = MathUtil.range(MenuPagged.this.currentPage - 1, 1, MenuPagged.this.pages.size());
                    MenuPagged.this.updatePage();
                }
            }

            @Override
            public ItemStack getItem() {
                int str = MenuPagged.this.currentPage - 1;
                return ItemCreator.of(this.canGo ? CompMaterial.LIME_DYE : CompMaterial.GRAY_DYE).name(str == 0 ? "&7First Page" : "&8<< &fPage " + str).build().make();
            }
        } : Button.makeEmpty();
        this.nextButton = hasPages ? new Button(){
            final boolean canGo;
            {
                this.canGo = MenuPagged.this.currentPage < MenuPagged.this.pages.size();
            }

            @Override
            public void onClickedInMenu(Player pl, Menu menu, ClickType click) {
                if (this.canGo) {
                    MenuPagged.this.currentPage = MathUtil.range(MenuPagged.this.currentPage + 1, 1, MenuPagged.this.pages.size());
                    MenuPagged.this.updatePage();
                }
            }

            @Override
            public ItemStack getItem() {
                boolean last = MenuPagged.this.currentPage == MenuPagged.this.pages.size();
                return ItemCreator.of(this.canGo ? CompMaterial.LIME_DYE : CompMaterial.GRAY_DYE).name(last ? "&7Last Page" : "Page " + (MenuPagged.this.currentPage + 1) + " &8>>").build().make();
            }
        } : Button.makeEmpty();
    }

    private void updatePage() {
        this.setButtons();
        this.redraw();
        this.registerButtons();
        Menu.getSound().play(this.getViewer());
        PlayerUtil.updateInventoryTitle(this.getViewer(), this.compileTitle0());
    }

    private String compileTitle0() {
        boolean canAddNumbers = this.addPageNumbers() && this.pages.size() > 1;
        return this.getTitle() + (canAddNumbers ? " &8" + this.currentPage + "/" + this.pages.size() : "");
    }

    @Override
    protected final void onDisplay(InventoryDrawer drawer) {
        drawer.setTitle(this.compileTitle0());
    }

    protected abstract ItemStack convertToItemStack(T var1);

    protected abstract void onPageClick(Player var1, T var2, ClickType var3);

    protected boolean updateButtonOnClick() {
        return true;
    }

    protected boolean addPageNumbers() {
        return true;
    }

    protected boolean isEmpty() {
        return this.pages.isEmpty() || this.pages.get(0).isEmpty();
    }

    @Override
    public ItemStack getItemAt(int slot) {
        T object;
        if (slot < this.getCurrentPageItems().size() && (object = this.getCurrentPageItems().get(slot)) != null) {
            return this.convertToItemStack(object);
        }
        if (slot == this.nextPageSlot) {
            return this.prevButton.getItem();
        }
        if (slot == this.previousPageSlot) {
            return this.nextButton.getItem();
        }
        return null;
    }

    @Override
    public final void onMenuClick(Player player, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        T obj;
        if (slot < this.getCurrentPageItems().size() && (obj = this.getCurrentPageItems().get(slot)) != null) {
            InventoryType prevType = player.getOpenInventory().getType();
            this.onPageClick(player, obj, click);
            if (this.updateButtonOnClick() && prevType == player.getOpenInventory().getType()) {
                player.getOpenInventory().getTopInventory().setItem(slot, this.getItemAt(slot));
            }
        }
    }

    @Override
    public final void onButtonClick(Player player, int slot, InventoryAction action, ClickType click, Button button) {
        super.onButtonClick(player, slot, action, click, button);
    }

    @Override
    public final void onMenuClick(Player player, int slot, ItemStack clicked) {
        throw new FoException("Simplest click unsupported");
    }

    private List<T> getCurrentPageItems() {
        Valid.checkBoolean(this.pages.containsKey(this.currentPage - 1), "The menu has only " + this.pages.size() + " pages, not " + this.currentPage + "!", new Object[0]);
        return this.pages.get(this.currentPage - 1);
    }

    public Map<Integer, List<T>> getPages() {
        return this.pages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

