/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.menu;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.ItemUtil;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.constants.FoConstants;
import org.mineacademy.fo.event.MenuOpenEvent;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.menu.button.Button;
import org.mineacademy.fo.menu.button.ButtonReturnBack;
import org.mineacademy.fo.menu.model.InventoryDrawer;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.menu.model.MenuClickLocation;
import org.mineacademy.fo.model.SimpleSound;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.CompSound;

public abstract class Menu {
    private static SimpleSound sound = new SimpleSound(CompSound.NOTE_STICKS.getSound(), 0.4f, 1.0f, true);
    private static boolean titleAnimationEnabled = true;
    private static int titleAnimationDurationTicks = 20;
    private final List<Button> registeredButtons = new ArrayList<Button>();
    private boolean buttonsRegistered = false;
    private final Menu parent;
    private final Button returnButton;
    private String title = "&0Menu";
    private Integer size = 27;
    private String[] info = null;
    private Player viewer;
    private boolean slotNumbersVisible;

    protected Menu() {
        this(null);
    }

    protected Menu(Menu parent) {
        this(parent, false);
    }

    protected Menu(Menu parent, boolean returnMakesNewInstance) {
        this.parent = parent;
        this.returnButton = parent != null ? new ButtonReturnBack(parent, returnMakesNewInstance) : Button.makeEmpty();
    }

    public static final Menu getMenu(Player player) {
        return Menu.getMenu0(player, FoConstants.NBT.TAG_MENU_CURRENT);
    }

    public static final Menu getPreviousMenu(Player player) {
        return Menu.getMenu0(player, FoConstants.NBT.TAG_MENU_PREVIOUS);
    }

    private static Menu getMenu0(Player player, String tag) {
        if (player.hasMetadata(tag)) {
            Menu menu = (Menu)((MetadataValue)player.getMetadata(tag).get(0)).value();
            Valid.checkNotNull(menu, "Menu missing from " + player.getName() + "'s metadata '" + tag + "' tag!");
            return menu;
        }
        return null;
    }

    protected final void registerButtons() {
        this.registeredButtons.clear();
        List<Button> buttons = this.getButtonsToAutoRegister();
        if (buttons != null) {
            this.registeredButtons.addAll(buttons);
        }
        Class<?> lookup = this.getClass();
        do {
            for (Field f : lookup.getDeclaredFields()) {
                this.registerButton0(f);
            }
        } while (Menu.class.isAssignableFrom(lookup = lookup.getSuperclass()));
    }

    private void registerButton0(Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (Button.class.isAssignableFrom(type)) {
            Button button = (Button)ReflectionUtil.getFieldContent(field, this);
            Valid.checkNotNull(button, "Null button field named " + field.getName() + " in " + this);
            this.registeredButtons.add(button);
        } else if (Button[].class.isAssignableFrom(type)) {
            Valid.checkBoolean(Modifier.isFinal(field.getModifiers()), "Report / Button[] field must be final: " + field, new Object[0]);
            Button[] buttons = (Button[])ReflectionUtil.getFieldContent(field, this);
            Valid.checkBoolean(buttons != null && buttons.length > 0, "Null " + field.getName() + "[] in " + this, new Object[0]);
            this.registeredButtons.addAll(Arrays.asList(buttons));
        }
    }

    private final void registerButtonsIfHasnt() {
        if (!this.buttonsRegistered) {
            this.registerButtons();
            this.buttonsRegistered = true;
        }
    }

    @Deprecated
    protected List<Button> getButtonsToAutoRegister() {
        return null;
    }

    protected final Button getButton(ItemStack fromItem) {
        this.registerButtonsIfHasnt();
        if (fromItem != null) {
            for (Button button : this.registeredButtons) {
                Valid.checkNotNull(button, "Menu button is null at " + this.getClass().getSimpleName());
                Valid.checkNotNull(button.getItem(), "Menu " + this.getTitle() + " contained button " + button + " with empty item!");
                if (!ItemUtil.isSimilar(fromItem, button.getItem())) continue;
                return button;
            }
        }
        return null;
    }

    public Menu newInstance() {
        try {
            return (Menu)ReflectionUtil.instantiate(this.getClass());
        }
        catch (Throwable t) {
            try {
                Object parent = this.getClass().getMethod("getParent", new Class[0]).invoke(this.getClass(), new Object[0]);
                if (parent != null) {
                    return (Menu)ReflectionUtil.instantiate(this.getClass(), parent);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            t.printStackTrace();
            throw new FoException("Could not instantiate menu of " + this.getClass() + ", override the method 'newInstance()' or ensure you have a public constructor which takes only one parameter ");
        }
    }

    public final void displayTo(Player player) {
        Valid.checkNotNull(this.size, "Size not set in " + this + " (call setSize in your constructor)");
        Valid.checkNotNull(this.title, "Title not set in " + this + " (call setTitle in your constructor)");
        this.viewer = player;
        this.registerButtonsIfHasnt();
        InventoryDrawer drawer = InventoryDrawer.of(this.size, this.title);
        this.compileBottomBar0().forEach((slot, item) -> drawer.setItem((int)slot, (ItemStack)item));
        for (int i = 0; i < drawer.getSize(); ++i) {
            ItemStack item2 = this.getItemAt(i);
            if (item2 == null || drawer.isSet(i)) continue;
            drawer.setItem(i, item2);
        }
        this.onDisplay(drawer);
        this.debugSlotNumbers(drawer);
        if (!Common.callEvent(new MenuOpenEvent(this, drawer, player))) {
            return;
        }
        if (player.isConversing()) {
            player.sendRawMessage(ChatColor.RED + "Type 'exit' to quit your conversation before opening menu.");
            return;
        }
        sound.play(player);
        Menu previous = Menu.getMenu(player);
        if (previous != null) {
            player.setMetadata(FoConstants.NBT.TAG_MENU_PREVIOUS, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)previous));
        }
        Common.runLater(1, () -> {
            drawer.display(player);
            player.setMetadata(FoConstants.NBT.TAG_MENU_CURRENT, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)this));
        });
    }

    private void debugSlotNumbers(InventoryDrawer drawer) {
        if (this.slotNumbersVisible) {
            for (int slot = 0; slot < drawer.getSize(); ++slot) {
                ItemStack item = drawer.getItem(slot);
                if (item != null) continue;
                drawer.setItem(slot, ItemCreator.of(CompMaterial.LIGHT_GRAY_STAINED_GLASS_PANE, "Slot " + slot, new String[0]).build().make());
            }
        }
    }

    protected void onDisplay(InventoryDrawer drawer) {
    }

    public final void restartMenu() {
        this.restartMenu(null);
    }

    public final void restartMenu(String animatedTitle) {
        this.registerButtons();
        this.redraw();
        if (animatedTitle != null) {
            this.animateTitle(animatedTitle);
        }
    }

    protected final void redraw() {
        Inventory inv = this.getViewer().getOpenInventory().getTopInventory();
        Valid.checkBoolean(inv.getType() == InventoryType.CHEST, this.getViewer().getName() + "'s inventory closed in the meanwhile (now == " + inv.getType() + ").", new Object[0]);
        for (int i = 0; i < this.size; ++i) {
            ItemStack item2 = this.getItemAt(i);
            Valid.checkBoolean(i < inv.getSize(), "Item (" + (item2 != null ? item2.getType() : "null") + ") position (" + i + ") > inv size (" + inv.getSize() + ")", new Object[0]);
            inv.setItem(i, item2);
        }
        this.compileBottomBar0().forEach((slot, item) -> inv.setItem(slot.intValue(), item));
        this.getViewer().updateInventory();
    }

    private Map<Integer, ItemStack> compileBottomBar0() {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        if (this.addInfoButton() && this.getInfo() != null) {
            items.put(this.getInfoButtonPosition(), Button.makeInfo(this.getInfo()).getItem());
        }
        if (this.addReturnButton() && !(this.returnButton instanceof Button.DummyButton)) {
            items.put(this.getReturnButtonPosition(), this.returnButton.getItem());
        }
        return items;
    }

    public final void animateTitle(String title) {
        if (titleAnimationEnabled) {
            PlayerUtil.updateInventoryTitle(this, this.getViewer(), title, this.getTitle(), titleAnimationDurationTicks);
        }
    }

    public ItemStack getItemAt(int slot) {
        return null;
    }

    protected int getInfoButtonPosition() {
        return this.size - 9;
    }

    protected boolean addReturnButton() {
        return true;
    }

    protected boolean addInfoButton() {
        return true;
    }

    protected int getReturnButtonPosition() {
        return this.size - 1;
    }

    protected final int getCenterSlot() {
        int pos = this.size / 2;
        return this.size % 2 == 1 ? pos : pos - 5;
    }

    @Deprecated
    protected boolean isActionAllowed(MenuClickLocation location, int slot, ItemStack clicked, ItemStack cursor) {
        return false;
    }

    public final String getTitle() {
        return this.title;
    }

    protected final void setTitle(String title) {
        this.title = title;
    }

    public final Menu getParent() {
        return this.parent;
    }

    public final Integer getSize() {
        return this.size;
    }

    protected final void setSize(Integer size) {
        this.size = size;
    }

    protected final void setInfo(String ... info) {
        this.info = info;
    }

    protected final Player getViewer() {
        return this.viewer;
    }

    protected final void setViewer(Player viewer) {
        this.viewer = viewer;
    }

    protected final Inventory getInventory() {
        Valid.checkNotNull(this.viewer, "Cannot get inventory when there is no viewer!");
        Inventory topInventory = this.viewer.getOpenInventory().getTopInventory();
        Valid.checkNotNull(topInventory, "Top inventory is null!");
        return topInventory;
    }

    protected final ItemStack[] getContent(int from, int to) {
        ItemStack[] content = this.getInventory().getContents();
        ItemStack[] copy = new ItemStack[content.length];
        for (int i = from; i < copy.length; ++i) {
            ItemStack item = content[i];
            copy[i] = item != null ? item.clone() : null;
        }
        return Arrays.copyOfRange(copy, from, to);
    }

    protected final void setSlotNumbersVisible() {
        this.slotNumbersVisible = true;
    }

    protected void onMenuClick(Player player, int slot, InventoryAction action, ClickType click, ItemStack cursor, ItemStack clicked, boolean cancelled) {
        this.onMenuClick(player, slot, clicked);
    }

    protected void onMenuClick(Player player, int slot, ItemStack clicked) {
    }

    protected void onButtonClick(Player player, int slot, InventoryAction action, ClickType click, Button button) {
        button.onClickedInMenu(player, this, click);
    }

    protected void onMenuClose(Player player, Inventory inventory) {
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }

    public static SimpleSound getSound() {
        return sound;
    }

    public static void setSound(SimpleSound sound) {
        Menu.sound = sound;
    }

    public static boolean isTitleAnimationEnabled() {
        return titleAnimationEnabled;
    }

    public static void setTitleAnimationEnabled(boolean titleAnimationEnabled) {
        Menu.titleAnimationEnabled = titleAnimationEnabled;
    }

    public static void setTitleAnimationDurationTicks(int titleAnimationDurationTicks) {
        Menu.titleAnimationDurationTicks = titleAnimationDurationTicks;
    }

    protected String[] getInfo() {
        return this.info;
    }
}

