/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.mineacademy.fo.jsonsimple.JSONArray;
import org.mineacademy.fo.jsonsimple.JSONObject;
import org.mineacademy.fo.jsonsimple.JSONUtil;

public final class JsonSimpleUtil {
    private JsonSimpleUtil() {
    }

    public static void write(byte[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(short[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(int[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(long[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(float[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(double[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(boolean[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static void write(char[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            writer.write("" + array[0]);
            for (int index = 1; index < array.length; ++index) {
                writer.write(",");
                writer.write("" + array[index]);
            }
            writer.write("]");
        }
    }

    public static <T> void write(T[] array, Writer writer) throws IOException {
        if (array == null) {
            writer.write("null");
        } else if (array.length == 0) {
            writer.write("[]");
        } else {
            writer.write("[");
            JsonSimpleUtil.write(array[0], writer);
            for (int i = 1; i < array.length; ++i) {
                writer.write(",");
                JsonSimpleUtil.write(array[i], writer);
            }
            writer.write("]");
        }
    }

    public static void write(Collection<?> collection, Writer writer) throws IOException {
        if (collection != null) {
            boolean first = true;
            Iterator<?> iterator = collection.iterator();
            writer.write(91);
            while (iterator.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                Object value = iterator.next();
                if (value == null) {
                    writer.write("null");
                    continue;
                }
                JsonSimpleUtil.write(value, writer);
            }
            writer.write(93);
        } else {
            writer.write("null");
        }
    }

    public static void write(Map<?, ?> map, Writer writer) throws IOException {
        if (map != null) {
            boolean first = true;
            writer.write(123);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                writer.write(34);
                writer.write(JSONUtil.escape(String.valueOf(entry.getKey())));
                writer.write(34);
                writer.write(58);
                JsonSimpleUtil.write(entry.getValue(), writer);
            }
            writer.write(125);
        } else {
            writer.write("null");
        }
    }

    public static void write(Object value, Writer writer) throws IOException {
        if (value == null) {
            writer.write("null");
        } else if (value instanceof String) {
            writer.write(34);
            writer.write(JSONUtil.escape((String)value));
            writer.write(34);
        } else if (value instanceof Double) {
            writer.write(((Double)value).isInfinite() || ((Double)value).isNaN() ? "null" : value.toString());
        } else if (value instanceof Float) {
            writer.write(((Float)value).isInfinite() || ((Float)value).isNaN() ? "null" : value.toString());
        } else if (value instanceof Number) {
            writer.write(value.toString());
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer);
        } else if (value instanceof Map) {
            JsonSimpleUtil.write((Map)value, writer);
        } else if (value instanceof Collection) {
            JsonSimpleUtil.write((Collection)value, writer);
        } else if (value instanceof byte[]) {
            JsonSimpleUtil.write((byte[])value, writer);
        } else if (value instanceof short[]) {
            JsonSimpleUtil.write((short[])value, writer);
        } else if (value instanceof int[]) {
            JsonSimpleUtil.write((int[])value, writer);
        } else if (value instanceof long[]) {
            JsonSimpleUtil.write((long[])value, writer);
        } else if (value instanceof float[]) {
            JsonSimpleUtil.write((float[])value, writer);
        } else if (value instanceof double[]) {
            JsonSimpleUtil.write((double[])value, writer);
        } else if (value instanceof boolean[]) {
            JsonSimpleUtil.write((boolean[])value, writer);
        } else if (value instanceof char[]) {
            JsonSimpleUtil.write((char[])value, writer);
        } else if (value.getClass().isArray()) {
            JsonSimpleUtil.write((Object[])value, writer);
        } else {
            writer.write(34);
            writer.write(JSONUtil.escape(value.toString()));
            writer.write(34);
        }
    }

    public static JSONObject getObject(Object value) {
        if (value != null) {
            if (value instanceof JSONObject) {
                return (JSONObject)value;
            }
            if (value instanceof Map) {
                return new JSONObject((Map<?, ?>)((Map)value));
            }
        }
        return null;
    }

    public static JSONArray getArray(Object value) {
        if (value != null) {
            if (value instanceof JSONArray) {
                return (JSONArray)value;
            }
            if (value instanceof boolean[]) {
                return new JSONArray((boolean[])value);
            }
            if (value instanceof byte[]) {
                return new JSONArray((byte[])value);
            }
            if (value instanceof char[]) {
                return new JSONArray((char[])value);
            }
            if (value instanceof short[]) {
                return new JSONArray((short[])value);
            }
            if (value instanceof int[]) {
                return new JSONArray((int[])value);
            }
            if (value instanceof long[]) {
                return new JSONArray((long[])value);
            }
            if (value instanceof float[]) {
                return new JSONArray((float[])value);
            }
            if (value instanceof double[]) {
                return new JSONArray((double[])value);
            }
            if (value instanceof Collection) {
                return new JSONArray((Collection<?>)((Collection)value));
            }
            if (value.getClass().isArray()) {
                return new JSONArray(value);
            }
        }
        return null;
    }

    public static Boolean getBoolean(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (boolean)((Boolean)value);
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue() == 1L;
            }
        }
        return null;
    }

    public static Byte getByte(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof String) {
                return Byte.parseByte((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (byte)1 : 0;
            }
        }
        return null;
    }

    public static Short getShort(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                return Short.parseShort((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (short)1 : 0;
            }
        }
        return null;
    }

    public static Integer getInteger(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
        }
        return null;
    }

    public static Long getLong(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1L : 0L;
            }
        }
        return null;
    }

    public static Float getFloat(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            if (value instanceof Boolean) {
                return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
            }
        }
        return null;
    }

    public static Double getDouble(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
        }
        return null;
    }

    public static String getString(Object value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static Date getDate(Object value, DateFormat format) throws ParseException {
        if (value != null) {
            return value instanceof Date ? (Date)value : format.parse(value.toString());
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnum(Object value, Class<T> type) {
        if (value != null) {
            for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
                if (!enumConstant.name().equals(value.toString())) continue;
                return (T)enumConstant;
            }
        }
        return null;
    }

    public static void escape(String string, StringBuilder builder) {
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character == '\"') {
                builder.append("\\\"");
                continue;
            }
            if (character == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (character == '\b') {
                builder.append("\\b");
                continue;
            }
            if (character == '\f') {
                builder.append("\\f");
                continue;
            }
            if (character == '\n') {
                builder.append("\\n");
                continue;
            }
            if (character == '\r') {
                builder.append("\\r");
                continue;
            }
            if (character == '\t') {
                builder.append("\\t");
                continue;
            }
            if (character == '/') {
                builder.append("\\/");
                continue;
            }
            if (character >= '\u0000' && character <= '\u001f' || character >= '\u007f' && character <= '\u009f' || character >= '\u2000' && character <= '\u20ff') {
                String hex = Integer.toHexString(character);
                builder.append("\\u");
                for (int k = 0; k < 4 - hex.length(); ++k) {
                    builder.append('0');
                }
                builder.append(hex.toUpperCase());
                continue;
            }
            builder.append(character);
        }
    }
}

