/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.mineacademy.fo.jsonsimple.JSONArray;
import org.mineacademy.fo.jsonsimple.JSONAttribute;
import org.mineacademy.fo.jsonsimple.JSONObject;
import org.mineacademy.fo.jsonsimple.JSONRoot;
import org.mineacademy.fo.jsonsimple.JSONTypeSerializationHandler;

public final class JSONSerializer {
    private JSONSerializer() {
    }

    public static void deserialize(JSONObject json, Object object) throws Exception {
        Object value;
        Class<?> targetType;
        JSONAttribute annotation;
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getFields();
        Method[] methods = clazz.getMethods();
        block0: for (Field field : fields) {
            annotation = field.getAnnotation(JSONAttribute.class);
            if (Modifier.isTransient(field.getModifiers()) || annotation == null || !JSONSerializer.contains(JSONAttribute.Type.SETTER, annotation)) continue;
            targetType = field.getType();
            value = json.get(annotation.name());
            if (value == null) continue;
            if (Float.TYPE.isAssignableFrom(targetType) || Float.class.isAssignableFrom(targetType)) {
                field.set(object, Float.valueOf(((Number)value).floatValue()));
                continue;
            }
            if (Double.TYPE.isAssignableFrom(targetType) || Double.class.isAssignableFrom(targetType)) {
                field.set(object, ((Number)value).doubleValue());
                continue;
            }
            if (Byte.TYPE.isAssignableFrom(targetType) || Byte.class.isAssignableFrom(targetType)) {
                field.set(object, ((Number)value).byteValue());
                continue;
            }
            if (Short.TYPE.isAssignableFrom(targetType) || Short.class.isAssignableFrom(targetType)) {
                field.set(object, ((Number)value).shortValue());
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(targetType) || Integer.class.isAssignableFrom(targetType)) {
                field.set(object, ((Number)value).intValue());
                continue;
            }
            if (Long.TYPE.isAssignableFrom(targetType) || Long.class.isAssignableFrom(targetType)) {
                field.set(object, ((Number)value).longValue());
                continue;
            }
            if (String.class.isAssignableFrom(targetType) || Number.class.isAssignableFrom(targetType) || Boolean.class.isAssignableFrom(targetType) || Boolean.TYPE.isAssignableFrom(targetType)) {
                field.set(object, value);
                continue;
            }
            if (Enum.class.isAssignableFrom(targetType)) {
                for (Object constant : targetType.getEnumConstants()) {
                    if (!((Enum)constant).name().equals(value.toString())) continue;
                    field.set(object, constant);
                    continue block0;
                }
                continue;
            }
            if (targetType.getAnnotation(JSONRoot.class) != null) {
                Object obj = targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize((JSONObject)value, obj);
                field.set(object, obj);
                continue;
            }
            if (Map.class.isAssignableFrom(targetType)) {
                Map map = (Map)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, object, map, (JSONObject)value);
                field.set(object, map);
                continue;
            }
            if (Collection.class.isAssignableFrom(targetType)) {
                Collection collection = (Collection)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, object, collection, (JSONArray)value);
                field.set(object, collection);
                continue;
            }
            if (targetType.isArray()) {
                Object object2 = Array.newInstance(targetType.getComponentType(), ((JSONArray)value).size());
                JSONSerializer.deserialize(clazz, object, object2, (JSONArray)value);
                field.set(object, object2);
                continue;
            }
            if (!JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) continue;
            field.set(object, ((JSONTypeSerializationHandler)object).deserialize(targetType, value));
        }
        block2: for (AccessibleObject accessibleObject : methods) {
            annotation = ((Method)accessibleObject).getAnnotation(JSONAttribute.class);
            if (Modifier.isTransient(((Method)accessibleObject).getModifiers()) || annotation == null || !JSONSerializer.contains(JSONAttribute.Type.SETTER, annotation)) continue;
            targetType = ((Method)accessibleObject).getParameterTypes()[0];
            if (targetType.isInterface()) {
                throw new Exception("Cannot deserialize an interface! Method: " + ((Method)accessibleObject).getName() + ", Interface: " + targetType.getName());
            }
            value = json.get(annotation.name());
            if (value == null) continue;
            if (Float.TYPE.isAssignableFrom(targetType) || Float.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, Float.valueOf(((Number)value).floatValue()));
                continue;
            }
            if (Double.TYPE.isAssignableFrom(targetType) || Double.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, ((Number)value).doubleValue());
                continue;
            }
            if (Byte.TYPE.isAssignableFrom(targetType) || Byte.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, ((Number)value).byteValue());
                continue;
            }
            if (Short.TYPE.isAssignableFrom(targetType) || Short.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, ((Number)value).shortValue());
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(targetType) || Integer.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, ((Number)value).intValue());
                continue;
            }
            if (Long.TYPE.isAssignableFrom(targetType) || Long.class.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, ((Number)value).longValue());
                continue;
            }
            if (String.class.isAssignableFrom(targetType) || Number.class.isAssignableFrom(targetType) || Boolean.class.isAssignableFrom(targetType) || Boolean.TYPE.isAssignableFrom(targetType)) {
                ((Method)accessibleObject).invoke(object, value);
                continue;
            }
            if (Enum.class.isAssignableFrom(targetType)) {
                for (Object constant : targetType.getEnumConstants()) {
                    if (!((Enum)constant).name().equals(value.toString())) continue;
                    ((Method)accessibleObject).invoke(object, constant);
                    continue block2;
                }
                continue;
            }
            if (targetType.getAnnotation(JSONRoot.class) != null) {
                Object obj = targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize((JSONObject)value, obj);
                ((Method)accessibleObject).invoke(object, obj);
                continue;
            }
            if (Map.class.isAssignableFrom(targetType)) {
                Map map = (Map)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, object, map, (JSONObject)value);
                ((Method)accessibleObject).invoke(object, map);
                continue;
            }
            if (Collection.class.isAssignableFrom(targetType)) {
                Collection collection = (Collection)targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, object, collection, (JSONArray)value);
                ((Method)accessibleObject).invoke(object, collection);
                continue;
            }
            if (targetType.isArray()) {
                Object object3 = Array.newInstance(targetType.getComponentType(), ((JSONArray)value).size());
                JSONSerializer.deserialize(clazz, object, object3, (JSONArray)value);
                ((Method)accessibleObject).invoke(object, object3);
                continue;
            }
            if (!JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) continue;
            ((Method)accessibleObject).invoke(object, ((JSONTypeSerializationHandler)object).deserialize(targetType, value));
        }
    }

    private static void deserialize(Class<?> clazz, Object classObject, Collection<Object> collection, JSONArray json) throws Exception {
        block0: for (Object value : json) {
            if (value != null) {
                Class<?> type = value.getClass();
                if (type.isInterface()) {
                    throw new Exception("Cannot deserialize an interface! Interface: " + type.getName());
                }
                if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    collection.add(Float.valueOf(((Number)value).floatValue()));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                    collection.add(((Number)value).doubleValue());
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
                    collection.add(((Number)value).byteValue());
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
                    collection.add(((Number)value).shortValue());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    collection.add(((Number)value).intValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                    collection.add(((Number)value).longValue());
                    continue;
                }
                if (String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                    collection.add(value);
                    continue;
                }
                if (Enum.class.isAssignableFrom(type)) {
                    for (Object constant : type.getEnumConstants()) {
                        if (!((Enum)constant).name().equals(value.toString())) continue;
                        collection.add(constant);
                        continue block0;
                    }
                    continue;
                }
                if (type.getAnnotation(JSONRoot.class) != null) {
                    Object newObject = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize((JSONObject)value, newObject);
                    collection.add(newObject);
                    continue;
                }
                if (Map.class.isAssignableFrom(type)) {
                    Map newMap = (Map)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize(clazz, classObject, newMap, (JSONObject)value);
                    collection.add(newMap);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    Collection newCollection = (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize(clazz, classObject, newCollection, (JSONArray)value);
                    collection.add(newCollection);
                    continue;
                }
                if (type.isArray()) {
                    Object newArray = Array.newInstance(type.getComponentType(), ((JSONArray)value).size());
                    JSONSerializer.deserialize(clazz, classObject, newArray, (JSONArray)value);
                    collection.add(newArray);
                    continue;
                }
                if (!JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) continue;
                collection.add(((JSONTypeSerializationHandler)classObject).deserialize(type, value));
                continue;
            }
            collection.add(value);
        }
    }

    private static void deserialize(Class<?> clazz, Object classObject, Map<Object, Object> map, JSONObject json) throws Exception {
        block0: for (Map.Entry jsonEntry : json.entrySet()) {
            Map.Entry entry = jsonEntry;
            Object value = entry.getValue();
            if (value != null) {
                Class<?> type = value.getClass();
                if (type.isInterface()) {
                    throw new Exception("Cannot deserialize an interface! Interface: " + type.getName());
                }
                if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), Float.valueOf(((Number)value).floatValue()));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), ((Number)value).doubleValue());
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), ((Number)value).byteValue());
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), ((Number)value).shortValue());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), ((Number)value).intValue());
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                    map.put(entry.getKey(), ((Number)value).longValue());
                    continue;
                }
                if (String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                    map.put(entry.getKey(), value);
                    continue;
                }
                if (Enum.class.isAssignableFrom(type)) {
                    for (Object constant : type.getEnumConstants()) {
                        if (!((Enum)constant).name().equals(value.toString())) continue;
                        map.put(entry.getKey(), constant);
                        continue block0;
                    }
                    continue;
                }
                if (type.getAnnotation(JSONRoot.class) != null) {
                    Object newObject = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize((JSONObject)value, newObject);
                    map.put(entry.getKey(), newObject);
                    continue;
                }
                if (Map.class.isAssignableFrom(type)) {
                    Map newMap = (Map)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize(clazz, classObject, newMap, (JSONObject)value);
                    map.put(entry.getKey(), newMap);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    Collection collection = (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    JSONSerializer.deserialize(clazz, classObject, collection, (JSONArray)value);
                    map.put(entry.getKey(), collection);
                    continue;
                }
                if (type.isArray()) {
                    Object newArray = Array.newInstance(type.getComponentType(), ((JSONArray)value).size());
                    JSONSerializer.deserialize(clazz, classObject, newArray, (JSONArray)value);
                    map.put(entry.getKey(), newArray);
                    continue;
                }
                if (!JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) continue;
                map.put(entry.getKey(), ((JSONTypeSerializationHandler)classObject).deserialize(type, value));
                continue;
            }
            map.put(entry.getKey(), value);
        }
    }

    private static void deserialize(Class<?> clazz, Object classObject, Object targetObject, JSONArray json) throws Exception {
        Class<?> type = targetObject.getClass().getComponentType();
        if (type.isInterface()) {
            throw new Exception("Cannot deserialize an interface! Interface: " + type.getName());
        }
        block0: for (int index = 0; index < json.size(); ++index) {
            Object value = json.get(index);
            if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, Float.valueOf(((Number)value).floatValue()));
                continue;
            }
            if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, ((Number)value).doubleValue());
                continue;
            }
            if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, ((Number)value).byteValue());
                continue;
            }
            if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, ((Number)value).shortValue());
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, ((Number)value).intValue());
                continue;
            }
            if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
                Array.set(targetObject, index, ((Number)value).longValue());
                continue;
            }
            if (String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                Array.set(targetObject, index, value);
                continue;
            }
            if (Enum.class.isAssignableFrom(type)) {
                for (Object constant : type.getEnumConstants()) {
                    if (!((Enum)constant).name().equals(value.toString())) continue;
                    Array.set(targetObject, index, constant);
                    continue block0;
                }
                continue;
            }
            if (type.getAnnotation(JSONRoot.class) != null) {
                Object newObject = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize((JSONObject)value, newObject);
                Array.set(targetObject, index, newObject);
                continue;
            }
            if (Map.class.isAssignableFrom(type)) {
                Map map = (Map)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, classObject, map, (JSONObject)value);
                Array.set(targetObject, index, map);
                continue;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Collection collection = (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONSerializer.deserialize(clazz, classObject, collection, (JSONArray)value);
                Array.set(targetObject, index, collection);
                continue;
            }
            if (type.isArray()) {
                Object newArray = Array.newInstance(type.getComponentType(), ((JSONArray)value).size());
                JSONSerializer.deserialize(clazz, classObject, newArray, (JSONArray)value);
                Array.set(targetObject, index, newArray);
                continue;
            }
            if (!JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) continue;
            Array.set(targetObject, index, ((JSONTypeSerializationHandler)classObject).deserialize(type, value));
        }
    }

    public static JSONObject serialize(Object object) throws Exception {
        JSONAttribute annotation;
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getFields();
        Method[] methods = clazz.getMethods();
        JSONObject json = new JSONObject();
        for (Field field : fields) {
            annotation = field.getAnnotation(JSONAttribute.class);
            if (Modifier.isTransient(field.getModifiers()) || annotation == null || !JSONSerializer.contains(JSONAttribute.Type.GETTER, annotation)) continue;
            JSONSerializer.serialize(json, clazz, object, field.getType(), field.get(object), annotation);
        }
        for (AccessibleObject accessibleObject : methods) {
            annotation = ((Method)accessibleObject).getAnnotation(JSONAttribute.class);
            if (Modifier.isTransient(((Method)accessibleObject).getModifiers()) || annotation == null || !JSONSerializer.contains(JSONAttribute.Type.GETTER, annotation)) continue;
            JSONSerializer.serialize(json, clazz, object, ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).invoke(object, new Object[0]), annotation);
        }
        return json;
    }

    private static void serialize(JSONObject json, Class<?> clazz, Object classObject, Class<?> type, Object value, JSONAttribute annotation) throws Exception {
        if (value instanceof String || value instanceof Boolean) {
            json.put(annotation.name(), value);
        } else if (value instanceof Number) {
            json.put(annotation.name(), value != null ? Long.valueOf(((Number)value).longValue()) : null);
        } else if (value instanceof boolean[]) {
            json.put(annotation.name(), new JSONArray((boolean[])value));
        } else if (value instanceof byte[]) {
            json.put(annotation.name(), new JSONArray((byte[])value));
        } else if (value instanceof short[]) {
            json.put(annotation.name(), new JSONArray((short[])value));
        } else if (value instanceof int[]) {
            json.put(annotation.name(), new JSONArray((int[])value));
        } else if (value instanceof long[]) {
            json.put(annotation.name(), new JSONArray((long[])value));
        } else if (value instanceof float[]) {
            json.put(annotation.name(), new JSONArray((float[])value));
        } else if (value instanceof double[]) {
            json.put(annotation.name(), new JSONArray((double[])value));
        } else if (value != null && value.getClass().isArray()) {
            json.put(annotation.name(), JSONSerializer.serializeArray(value, clazz, classObject));
        } else if (value != null && value.getClass().getAnnotation(JSONRoot.class) != null) {
            json.put(annotation.name(), JSONSerializer.serialize(value));
        } else if (value instanceof Collection) {
            json.put(annotation.name(), JSONSerializer.serializeArray((Collection)value, clazz, classObject));
        } else if (value instanceof Map) {
            json.put(annotation.name(), JSONSerializer.serializeObject((Map)value, clazz, classObject));
        } else if (value instanceof Enum) {
            json.put(annotation.name(), ((Enum)value).name());
        } else if (JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) {
            json.put(annotation.name(), ((JSONTypeSerializationHandler)classObject).serialize(type, value));
        } else {
            json.put(annotation.name(), value);
        }
    }

    private static JSONObject serializeObject(Map<?, ?> map, Class<?> clazz, Object classObject) throws Exception {
        JSONObject json = new JSONObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof boolean[]) {
                json.put(entry.getKey(), new JSONArray((boolean[])value));
                continue;
            }
            if (value instanceof byte[]) {
                json.put(entry.getKey(), new JSONArray((byte[])value));
                continue;
            }
            if (value instanceof short[]) {
                json.put(entry.getKey(), new JSONArray((short[])value));
                continue;
            }
            if (value instanceof int[]) {
                json.put(entry.getKey(), new JSONArray((int[])value));
                continue;
            }
            if (value instanceof long[]) {
                json.put(entry.getKey(), new JSONArray((long[])value));
                continue;
            }
            if (value instanceof float[]) {
                json.put(entry.getKey(), new JSONArray((float[])value));
                continue;
            }
            if (value instanceof double[]) {
                json.put(entry.getKey(), new JSONArray((double[])value));
                continue;
            }
            if (value != null && value.getClass().getAnnotation(JSONRoot.class) != null) {
                json.put(entry.getKey(), JSONSerializer.serialize(value));
                continue;
            }
            if (value instanceof Map) {
                json.put(entry.getKey(), JSONSerializer.serializeObject((Map)value, clazz, classObject));
                continue;
            }
            if (value instanceof Collection) {
                json.put(entry.getKey(), JSONSerializer.serializeArray((Collection)value, clazz, classObject));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                json.put(entry.getKey(), JSONSerializer.serializeArray(value, clazz, classObject));
                continue;
            }
            if (value instanceof Enum) {
                json.put(entry.getKey(), ((Enum)value).name());
                continue;
            }
            if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                json.put(entry.getKey(), value);
                continue;
            }
            if (value != null && JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) {
                json.put(entry.getKey(), ((JSONTypeSerializationHandler)classObject).serialize(value.getClass(), value));
                continue;
            }
            json.put(entry.getKey(), value);
        }
        return json;
    }

    private static JSONArray serializeArray(Collection<?> collection, Class<?> clazz, Object classObject) throws Exception {
        JSONArray json = new JSONArray();
        for (Object value : collection) {
            if (value instanceof boolean[]) {
                json.add(new JSONArray((boolean[])value));
                continue;
            }
            if (value instanceof byte[]) {
                json.add(new JSONArray((byte[])value));
                continue;
            }
            if (value instanceof short[]) {
                json.add(new JSONArray((short[])value));
                continue;
            }
            if (value instanceof int[]) {
                json.add(new JSONArray((int[])value));
                continue;
            }
            if (value instanceof long[]) {
                json.add(new JSONArray((long[])value));
                continue;
            }
            if (value instanceof float[]) {
                json.add(new JSONArray((float[])value));
                continue;
            }
            if (value instanceof double[]) {
                json.add(new JSONArray((double[])value));
                continue;
            }
            if (value != null && value.getClass().getAnnotation(JSONRoot.class) != null) {
                json.add(JSONSerializer.serialize(value));
                continue;
            }
            if (value instanceof Map) {
                json.add(JSONSerializer.serializeObject((Map)value, clazz, classObject));
                continue;
            }
            if (value instanceof Collection) {
                json.add(JSONSerializer.serializeArray((Collection)value, clazz, classObject));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                json.add(JSONSerializer.serializeArray(value, clazz, classObject));
                continue;
            }
            if (value instanceof Enum) {
                json.add(((Enum)value).name());
                continue;
            }
            if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                json.add(value);
                continue;
            }
            if (value != null && JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) {
                ((JSONTypeSerializationHandler)classObject).serialize(value.getClass(), value);
                continue;
            }
            json.add(value);
        }
        return json;
    }

    private static JSONArray serializeArray(Object array, Class<?> clazz, Object classObject) throws Exception {
        JSONArray json = new JSONArray();
        for (int index = 0; index < Array.getLength(array); ++index) {
            Object value = Array.get(array, index);
            if (value instanceof boolean[]) {
                json.add(new JSONArray((boolean[])value));
                continue;
            }
            if (value instanceof byte[]) {
                json.add(new JSONArray((byte[])value));
                continue;
            }
            if (value instanceof short[]) {
                json.add(new JSONArray((short[])value));
                continue;
            }
            if (value instanceof int[]) {
                json.add(new JSONArray((int[])value));
                continue;
            }
            if (value instanceof long[]) {
                json.add(new JSONArray((long[])value));
                continue;
            }
            if (value instanceof float[]) {
                json.add(new JSONArray((float[])value));
                continue;
            }
            if (value instanceof double[]) {
                json.add(new JSONArray((double[])value));
                continue;
            }
            if (value != null && value.getClass().getAnnotation(JSONRoot.class) != null) {
                json.add(JSONSerializer.serialize(value));
                continue;
            }
            if (value instanceof Map) {
                json.add(JSONSerializer.serializeObject((Map)value, clazz, classObject));
                continue;
            }
            if (value instanceof Collection) {
                json.add(JSONSerializer.serializeArray((Collection)value, clazz, classObject));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                json.add(JSONSerializer.serializeArray(value, clazz, classObject));
                continue;
            }
            if (value instanceof Enum) {
                json.add(((Enum)value).name());
                continue;
            }
            if (value instanceof String || value instanceof Boolean || value instanceof Number) {
                json.add(value);
                continue;
            }
            if (value != null && JSONTypeSerializationHandler.class.isAssignableFrom(clazz)) {
                json.add(((JSONTypeSerializationHandler)classObject).serialize(value.getClass(), value));
                continue;
            }
            json.add(value);
        }
        return json;
    }

    private static boolean contains(JSONAttribute.Type type, JSONAttribute attribute) {
        for (JSONAttribute.Type value : attribute.type()) {
            if (!value.equals((Object)type)) continue;
            return true;
        }
        return false;
    }
}

