/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.jsonsimple.JSONArray;
import org.mineacademy.fo.jsonsimple.JSONContentHandler;
import org.mineacademy.fo.jsonsimple.JSONObject;
import org.mineacademy.fo.jsonsimple.JSONParseException;
import org.mineacademy.fo.jsonsimple.Yylex;
import org.mineacademy.fo.jsonsimple.Yytoken;

public class JSONParser {
    private static final JSONParser instance = new JSONParser();
    private static final int S_INIT = 0;
    private static final int S_IN_FINISHED_VALUE = 1;
    private static final int S_IN_OBJECT = 2;
    private static final int S_IN_ARRAY = 3;
    private static final int S_PASSED_PAIR_KEY = 4;
    private static final int S_IN_PAIR_VALUE = 5;
    private static final int S_END = 6;
    private static final int S_IN_ERROR = -1;
    private Stack<Object> handlerStatusStack;
    private final Yylex lexer = new Yylex((Reader)null);
    private Yytoken token;
    private int status = 0;

    private final void nextToken() throws JSONParseException, IOException {
        this.token = this.lexer.yylex();
        if (this.token == null) {
            this.token = new Yytoken(-1, null);
        }
    }

    private final void init(Stack<Object> statusStack, Stack<Object> valueStack) {
        if (this.token.type == 0) {
            this.status = 1;
            statusStack.push(this.status);
            valueStack.push(this.token.value);
        } else if (this.token.type == 1) {
            this.status = 2;
            statusStack.push(this.status);
            valueStack.push(new JSONObject());
        } else if (this.token.type == 3) {
            this.status = 3;
            statusStack.push(this.status);
            valueStack.push(new JSONArray());
        } else {
            this.status = -1;
        }
    }

    private final Object inFinishedValue(Stack<Object> valueStack) throws JSONParseException {
        if (this.token.type == -1) {
            return valueStack.pop();
        }
        throw new JSONParseException(this.getPosition(), 1, this.token);
    }

    private final void inObject(Stack<Object> statusStack, Stack<Object> valueStack) {
        if (this.token.type == 0) {
            if (this.token.value instanceof String) {
                String key = (String)this.token.value;
                valueStack.push(key);
                this.status = 4;
                statusStack.push(this.status);
            } else {
                this.status = -1;
            }
        } else if (this.token.type == 2) {
            if (valueStack.size() > 1) {
                statusStack.pop();
                valueStack.pop();
                this.status = (Integer)statusStack.peek();
            } else {
                this.status = 1;
            }
        } else if (this.token.type != 5) {
            this.status = -1;
        }
    }

    private final void inPassedPairKey(Stack<Object> statusStack, Stack<Object> valueStack) {
        if (this.token.type == 0) {
            statusStack.pop();
            String key = (String)valueStack.pop();
            Map parent = (Map)valueStack.peek();
            parent.put(key, this.token.value);
            this.status = (Integer)statusStack.peek();
        } else if (this.token.type == 3) {
            statusStack.pop();
            String key = (String)valueStack.pop();
            Map parent = (Map)valueStack.peek();
            JSONArray newArray = new JSONArray();
            parent.put(key, newArray);
            this.status = 3;
            statusStack.push(this.status);
            valueStack.push(newArray);
        } else if (this.token.type == 1) {
            statusStack.pop();
            String key = (String)valueStack.pop();
            Map parent = (Map)valueStack.peek();
            JSONObject newObject = new JSONObject();
            parent.put(key, newObject);
            this.status = 2;
            statusStack.push(this.status);
            valueStack.push(newObject);
        } else if (this.token.type != 6) {
            this.status = -1;
        }
    }

    private final void inArray(Stack<Object> statusStack, Stack<Object> valueStack) {
        if (this.token.type == 0) {
            List val = (List)valueStack.peek();
            val.add(this.token.value);
        } else if (this.token.type == 4) {
            if (valueStack.size() > 1) {
                statusStack.pop();
                valueStack.pop();
                this.status = (Integer)statusStack.peek();
            } else {
                this.status = 1;
            }
        } else if (this.token.type == 1) {
            List val = (List)valueStack.peek();
            JSONObject newObject = new JSONObject();
            val.add(newObject);
            this.status = 2;
            statusStack.push(this.status);
            valueStack.push(newObject);
        } else if (this.token.type == 3) {
            List val = (List)valueStack.peek();
            JSONArray newArray = new JSONArray();
            val.add(newArray);
            this.status = 3;
            statusStack.push(this.status);
            valueStack.push(newArray);
        } else if (this.token.type != 5) {
            this.status = -1;
        }
    }

    public void reset() {
        this.token = null;
        this.status = 0;
        this.handlerStatusStack = null;
    }

    public void reset(Reader reader) {
        this.lexer.yyreset(reader);
        this.reset();
    }

    public int getPosition() {
        return this.lexer.getPosition();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parse(String json) throws JSONParseException {
        try (StringReader reader = new StringReader(json);){
            Object object = this.parse(reader);
            return object;
        }
        catch (IOException exception) {
            throw new FoException(exception);
        }
    }

    public Object parse(Reader reader) throws IOException, JSONParseException {
        this.reset(reader);
        Stack<Object> statusStack = new Stack<Object>();
        Stack<Object> valueStack = new Stack<Object>();
        do {
            this.nextToken();
            if (this.status == 0) {
                this.init(statusStack, valueStack);
            } else {
                if (this.status == 1) {
                    return this.inFinishedValue(valueStack);
                }
                if (this.status == 2) {
                    this.inObject(statusStack, valueStack);
                } else if (this.status == 4) {
                    this.inPassedPairKey(statusStack, valueStack);
                } else if (this.status == 3) {
                    this.inArray(statusStack, valueStack);
                }
            }
            if (this.status != -1) continue;
            throw new JSONParseException(this.getPosition(), 1, this.token);
        } while (this.token.type != -1);
        throw new JSONParseException(this.getPosition(), 1, this.token);
    }

    public void parse(String string, JSONContentHandler contentHandler) throws JSONParseException {
        this.parse(string != null ? string.trim() : null, contentHandler, false);
    }

    public void parse(String string, JSONContentHandler contentHandler, boolean resume) throws JSONParseException {
        try (StringReader reader = new StringReader(string != null ? string.trim() : null);){
            this.parse(reader, contentHandler, resume);
        }
        catch (IOException exception) {
            throw new JSONParseException(-1, 2, exception);
        }
    }

    public void parse(Reader reader, JSONContentHandler contentHandler) throws IOException, JSONParseException {
        this.parse(reader, contentHandler, false);
    }

    public void parse(Reader reader, JSONContentHandler contentHandler, boolean resume) throws IOException, JSONParseException {
        if (!resume) {
            this.reset(reader);
            this.handlerStatusStack = new Stack();
        } else if (this.handlerStatusStack == null) {
            this.reset(reader);
            this.handlerStatusStack = new Stack();
        }
        Stack<Object> statusStack = this.handlerStatusStack;
        try {
            do {
                if (this.status == 0) {
                    contentHandler.startJSON();
                    this.nextToken();
                    if (this.token.type == 0) {
                        this.status = 1;
                        statusStack.push(this.status);
                        if (!contentHandler.primitive(this.token.value)) {
                            return;
                        }
                    } else if (this.token.type == 1) {
                        this.status = 2;
                        statusStack.push(this.status);
                        if (!contentHandler.startObject()) {
                            return;
                        }
                    } else if (this.token.type == 3) {
                        this.status = 3;
                        statusStack.push(this.status);
                        if (!contentHandler.startArray()) {
                            return;
                        }
                    } else {
                        this.status = -1;
                    }
                } else if (this.status == 1) {
                    this.nextToken();
                    if (this.token.type == -1) {
                        contentHandler.endJSON();
                        this.status = 6;
                        return;
                    }
                    this.status = -1;
                } else if (this.status == 2) {
                    this.nextToken();
                    if (this.token.type == 0) {
                        if (this.token.value instanceof String) {
                            String key = (String)this.token.value;
                            this.status = 4;
                            statusStack.push(this.status);
                            if (!contentHandler.startObjectEntry(key)) {
                                return;
                            }
                        } else {
                            this.status = -1;
                        }
                    } else if (this.token.type == 2) {
                        if (statusStack.size() > 1) {
                            statusStack.pop();
                            this.status = (Integer)statusStack.peek();
                        } else {
                            this.status = 1;
                        }
                        if (!contentHandler.endObject()) {
                            return;
                        }
                    } else if (this.token.type != 5) {
                        this.status = -1;
                    }
                } else if (this.status == 4) {
                    this.nextToken();
                    if (this.token.type == 0) {
                        statusStack.pop();
                        this.status = (Integer)statusStack.peek();
                        if (!contentHandler.primitive(this.token.value) || !contentHandler.endObjectEntry()) {
                            return;
                        }
                    } else if (this.token.type == 3) {
                        statusStack.pop();
                        statusStack.push(5);
                        this.status = 3;
                        statusStack.push(this.status);
                        if (!contentHandler.startArray()) {
                            return;
                        }
                    } else if (this.token.type == 1) {
                        statusStack.pop();
                        statusStack.push(5);
                        this.status = 2;
                        statusStack.push(this.status);
                        if (!contentHandler.startObject()) {
                            return;
                        }
                    } else if (this.token.type != 6) {
                        this.status = -1;
                    }
                } else if (this.status == 5) {
                    statusStack.pop();
                    this.status = (Integer)statusStack.peek();
                    if (!contentHandler.endObjectEntry()) {
                        return;
                    }
                } else if (this.status == 3) {
                    this.nextToken();
                    if (this.token.type == 0) {
                        if (!contentHandler.primitive(this.token.value)) {
                            return;
                        }
                    } else if (this.token.type == 4) {
                        if (statusStack.size() > 1) {
                            statusStack.pop();
                            this.status = (Integer)statusStack.peek();
                        } else {
                            this.status = 1;
                        }
                        if (!contentHandler.endArray()) {
                            return;
                        }
                    } else if (this.token.type == 1) {
                        this.status = 2;
                        statusStack.push(this.status);
                        if (!contentHandler.startObject()) {
                            return;
                        }
                    } else if (this.token.type == 3) {
                        this.status = 3;
                        statusStack.push(this.status);
                        if (!contentHandler.startArray()) {
                            return;
                        }
                    } else if (this.token.type != 5) {
                        this.status = -1;
                    }
                } else if (this.status == 6) {
                    return;
                }
                if (this.status != -1) continue;
                throw new JSONParseException(this.getPosition(), 1, this.token);
            } while (this.token.type != -1);
        }
        catch (IOException | Error | RuntimeException | JSONParseException exception) {
            this.status = -1;
            throw exception;
        }
        this.status = -1;
        throw new JSONParseException(this.getPosition(), 1, this.token);
    }

    public static JSONParser getInstance() {
        return instance;
    }
}

