/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mineacademy.fo.jsonsimple.JSONArray;
import org.mineacademy.fo.jsonsimple.JSONParseException;
import org.mineacademy.fo.jsonsimple.JSONParser;
import org.mineacademy.fo.jsonsimple.JsonSimpleUtil;

public class JSONObject
extends LinkedHashMap<Object, Object> {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public JSONObject(Map<?, ?> map) {
        super(map);
    }

    public JSONObject(String json) throws JSONParseException {
        super((JSONObject)new JSONParser().parse(json));
    }

    public JSONObject(Reader reader) throws IOException, JSONParseException {
        super((JSONObject)new JSONParser().parse(reader));
    }

    public void write(Writer writer) throws IOException {
        JsonSimpleUtil.write(this, writer);
    }

    public JSONObject compact() {
        JSONObject object = new JSONObject();
        this.forEach((key, value) -> {
            if (value != null) {
                object.put(key, value);
            }
        });
        return object;
    }

    public JSONObject getObject(String key) {
        return JsonSimpleUtil.getObject(this.get(key));
    }

    public JSONArray getArray(String key) {
        return JsonSimpleUtil.getArray(this.get(key));
    }

    public Boolean getBoolean(String key) {
        return JsonSimpleUtil.getBoolean(this.get(key));
    }

    public Byte getByte(String key) {
        return JsonSimpleUtil.getByte(this.get(key));
    }

    public Short getShort(String key) {
        return JsonSimpleUtil.getShort(this.get(key));
    }

    public Integer getInteger(String key) {
        return JsonSimpleUtil.getInteger(this.get(key));
    }

    public Long getLong(String key) {
        return JsonSimpleUtil.getLong(this.get(key));
    }

    public Float getFloat(String key) {
        return JsonSimpleUtil.getFloat(this.get(key));
    }

    public Double getDouble(String key) {
        return JsonSimpleUtil.getDouble(this.get(key));
    }

    public String getString(String key) {
        return JsonSimpleUtil.getString(this.get(key));
    }

    public Date getDate(String key, DateFormat format) throws ParseException {
        return JsonSimpleUtil.getDate(this.get(key), format);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> type) {
        return JsonSimpleUtil.getEnum(this.get(key), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        try (StringWriter writer = new StringWriter();){
            JsonSimpleUtil.write(this, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                for (Map.Entry thisEntry : this.entrySet()) {
                    Object key = thisEntry.getKey();
                    Object value = thisEntry.getValue();
                    if (map.containsKey(key) && value.equals(map.get(key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toXML(String rootName) {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(rootName);
        builder.append('>');
        this.forEach((key, value) -> {
            if (value instanceof JSONObject) {
                builder.append(((JSONObject)value).toXML(key.toString()));
            } else if (value instanceof JSONArray) {
                builder.append(((JSONArray)value).toXML(key.toString()));
            } else {
                builder.append('<');
                builder.append(key);
                builder.append('>');
                if (value != null) {
                    builder.append(String.valueOf(value));
                }
                builder.append("</");
                builder.append(key);
                builder.append('>');
            }
        });
        builder.append("</");
        builder.append(rootName);
        builder.append('>');
        return builder.toString();
    }
}

