/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class JSONFormatter {
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";
    private int indent = 1;
    private char indentCharacter;
    private String lineBreak = "\n";

    public JSONFormatter() {
        this.setUseTabs(true);
    }

    private final void writeIndent(int level, Writer writer) throws IOException {
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            for (int indent = 0; indent < this.indent; ++indent) {
                writer.write(this.indentCharacter);
            }
        }
    }

    public void setUseCRLF(boolean crlf) {
        this.lineBreak = crlf ? CRLF : LF;
    }

    public void setUseTabs(boolean tabs) {
        this.indentCharacter = (char)(tabs ? 9 : 32);
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void format(Reader reader, Writer writer) throws IOException {
        int level = 0;
        boolean inString = false;
        int read = -1;
        int lastChar = 0;
        while ((read = reader.read()) != -1) {
            char character = (char)read;
            if (character == '\"') {
                boolean bl = inString = !inString || lastChar == 92;
            }
            if (!inString) {
                if (character == '{' || character == '[') {
                    writer.write(character);
                    writer.write(this.lineBreak);
                    this.writeIndent(++level, writer);
                    continue;
                }
                if (character == '}' || character == ']') {
                    writer.write(this.lineBreak);
                    this.writeIndent(--level, writer);
                    writer.write(character);
                    continue;
                }
                if (character == ',') {
                    writer.write(character);
                    writer.write(this.lineBreak);
                    this.writeIndent(level, writer);
                    continue;
                }
                if (character == ':') {
                    writer.write(character);
                    writer.write(32);
                    continue;
                }
            }
            writer.write(character);
            lastChar = character;
        }
    }

    /*
     * Exception decompiling
     */
    public String format(String json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void minimize(Reader reader, Writer writer) throws IOException {
        boolean inString = false;
        char lastChar = '\u0000';
        int read = -1;
        while ((read = reader.read()) != -1) {
            char character = (char)read;
            if (character != '\n' && character != '\t' && character != '\r' && character != '\b' && character != '\u0000' && character != '\f') {
                if (character == '\"') {
                    boolean bl = inString = !inString || lastChar == '\\';
                }
                if (character != ' ' || inString) {
                    writer.write(character);
                }
            }
            lastChar = character;
        }
    }

    /*
     * Exception decompiling
     */
    public String minimize(String json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean usesCRLF() {
        return CRLF.equals(this.lineBreak);
    }

    public boolean usesTabs() {
        return this.indentCharacter == '\t';
    }

    public int getIndent() {
        return this.indent;
    }
}

