/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.jsonsimple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.mineacademy.fo.jsonsimple.JSONObject;
import org.mineacademy.fo.jsonsimple.JSONParseException;
import org.mineacademy.fo.jsonsimple.JSONParser;
import org.mineacademy.fo.jsonsimple.JsonSimpleUtil;

public class JSONArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 3957988303675231981L;

    public JSONArray() {
    }

    public JSONArray(Collection<?> collection) {
        super(collection);
    }

    public <T> JSONArray(T[] array) {
        for (T element : array) {
            this.add(element);
        }
    }

    public JSONArray(byte[] array) {
        for (byte element : array) {
            this.add(element);
        }
    }

    public JSONArray(boolean[] array) {
        for (boolean element : array) {
            this.add(element);
        }
    }

    public JSONArray(char[] array) {
        for (char element : array) {
            this.add(Character.valueOf(element));
        }
    }

    public JSONArray(short[] array) {
        for (short element : array) {
            this.add(element);
        }
    }

    public JSONArray(int[] array) {
        for (int element : array) {
            this.add(element);
        }
    }

    public JSONArray(long[] array) {
        for (long element : array) {
            this.add(element);
        }
    }

    public JSONArray(float[] array) {
        for (float element : array) {
            this.add(Float.valueOf(element));
        }
    }

    public JSONArray(double[] array) {
        for (double element : array) {
            this.add(element);
        }
    }

    public JSONArray(Object array) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int index = 0; index < length; ++index) {
                this.add(Array.get(array, index));
            }
        }
    }

    public JSONArray(String json) throws JSONParseException {
        super((JSONArray)new JSONParser().parse(json));
    }

    public JSONArray(Reader reader) throws JSONParseException, IOException {
        super((JSONArray)new JSONParser().parse(reader));
    }

    public void write(Writer writer) throws IOException {
        JsonSimpleUtil.write(this, writer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        try (StringWriter writer = new StringWriter();){
            JsonSimpleUtil.write(this, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object != null) {
            int length;
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (collection.size() == this.size()) {
                    int index = 0;
                    for (Object element : collection) {
                        if (!(element == null && this.get(index) == null || this.get(index).equals(element))) {
                            return false;
                        }
                        ++index;
                    }
                    return true;
                }
            } else if (object.getClass().isArray() && (length = Array.getLength(object)) == this.size()) {
                for (int index = 0; index < length; ++index) {
                    Object element = Array.get(object, index);
                    if (element == null && this.get(index) == null || element.equals(this.get(index))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public JSONObject getObject(int index) {
        return JsonSimpleUtil.getObject(this.get(index));
    }

    public JSONArray getArray(int index) {
        return JsonSimpleUtil.getArray(this.get(index));
    }

    public Boolean getBoolean(int index) {
        return JsonSimpleUtil.getBoolean(this.get(index));
    }

    public Byte getByte(int index) {
        return JsonSimpleUtil.getByte(this.get(index));
    }

    public Short getShort(int index) {
        return JsonSimpleUtil.getShort(this.get(index));
    }

    public Integer getInteger(int index) {
        return JsonSimpleUtil.getInteger(this.get(index));
    }

    public Long getLong(int index) {
        return JsonSimpleUtil.getLong(this.get(index));
    }

    public Float getFloat(int index) {
        return JsonSimpleUtil.getFloat(this.get(index));
    }

    public Double getDouble(int index) {
        return JsonSimpleUtil.getDouble(this.get(index));
    }

    public String getString(int index) {
        return JsonSimpleUtil.getString(this.get(index));
    }

    public Date getDate(int index, DateFormat format) throws ParseException {
        return JsonSimpleUtil.getDate(this.get(index), format);
    }

    public <T extends Enum<T>> T getEnum(int index, Class<T> type) {
        return JsonSimpleUtil.getEnum(this.get(index), type);
    }

    public Boolean[] toBooleanArray() {
        Boolean[] array = new Boolean[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getBoolean(index);
        }
        return array;
    }

    public Byte[] toByteArray() {
        Byte[] array = new Byte[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getByte(index);
        }
        return array;
    }

    public Short[] toShortArray() {
        Short[] array = new Short[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getShort(index);
        }
        return array;
    }

    public Integer[] toIntegerArray() {
        Integer[] array = new Integer[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getInteger(index);
        }
        return array;
    }

    public Long[] toLongArray() {
        Long[] array = new Long[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getLong(index);
        }
        return array;
    }

    public Float[] toFloatArray() {
        Float[] array = new Float[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getFloat(index);
        }
        return array;
    }

    public Double[] toDoubleArray() {
        Double[] array = new Double[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getDouble(index);
        }
        return array;
    }

    public String[] toStringArray() {
        String[] array = new String[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getString(index);
        }
        return array;
    }

    public JSONObject[] toObjectArray() {
        JSONObject[] array = new JSONObject[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getObject(index);
        }
        return array;
    }

    public JSONArray[] toArrayArray() {
        JSONArray[] array = new JSONArray[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getArray(index);
        }
        return array;
    }

    public byte[] toPrimitiveByteArray() {
        byte[] array = new byte[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getByte(index);
        }
        return array;
    }

    public short[] toPrimitiveShortArray() {
        short[] array = new short[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getShort(index);
        }
        return array;
    }

    public int[] toPrimitiveIntArray() {
        int[] array = new int[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getInteger(index);
        }
        return array;
    }

    public long[] toPrimitiveLongArray() {
        long[] array = new long[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getLong(index);
        }
        return array;
    }

    public float[] toPrimitiveFloatArray() {
        float[] array = new float[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getFloat(index).floatValue();
        }
        return array;
    }

    public double[] toPrimitiveDoubleArray() {
        double[] array = new double[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getDouble(index);
        }
        return array;
    }

    public boolean[] toPrimitiveBooleanArray() {
        boolean[] array = new boolean[this.size()];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.getBoolean(index);
        }
        return array;
    }

    public String toXML(String rootName) {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(rootName);
        builder.append(" length=");
        builder.append(this.size());
        builder.append('>');
        for (Object element : this) {
            if (element instanceof JSONObject) {
                builder.append(((JSONObject)element).toXML("item"));
                continue;
            }
            if (element instanceof JSONArray) {
                builder.append(((JSONArray)element).toXML("item"));
                continue;
            }
            builder.append("<item>");
            if (element != null) {
                builder.append(String.valueOf(element));
            }
            builder.append("</item>");
        }
        builder.append("</");
        builder.append(rootName);
        builder.append('>');
        return builder.toString();
    }
}

