/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.event;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.debug.LagCatcher;
import org.mineacademy.fo.exception.EventHandledException;
import org.mineacademy.fo.plugin.SimplePlugin;

public abstract class SimpleListener<T extends Event>
implements Listener,
EventExecutor {
    private final Class<T> eventClass;
    private final EventPriority priority;
    private final boolean ignoreCancelled;
    private T event;

    public SimpleListener(Class<T> event) {
        this(event, EventPriority.NORMAL);
    }

    public SimpleListener(Class<T> event, EventPriority priority) {
        this(event, priority, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Listener listener, Event event) throws EventException {
        String logName = listener.getClass().getSimpleName() + " listening to " + event.getEventName() + " at " + this.priority + " priority";
        LagCatcher.start(logName);
        try {
            this.event = event;
            this.execute(event);
        }
        catch (EventHandledException ex) {
            String[] messages = ex.getMessages();
            boolean cancelled = ex.isCancelled();
            Player player = this.findPlayer(event);
            if (messages != null && player != null) {
                Common.tell((CommandSender)player, messages);
            }
            if (cancelled && event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(true);
            }
        }
        finally {
            LagCatcher.end(logName);
            this.event = null;
        }
    }

    public abstract void execute(T var1);

    protected Player findPlayer(T event) {
        return null;
    }

    protected final void checkBoolean(boolean condition, String ... falseMessages) {
        if (!condition) {
            throw new EventHandledException(true, falseMessages);
        }
    }

    protected final void checkPerm(String permission, String falseMessage) {
        Player player = this.findPlayer(this.event);
        Valid.checkNotNull(player, "Player cannot be null for " + this.event.getEventName() + "!");
        if (!PlayerUtil.hasPerm((Permissible)player, permission)) {
            throw new EventHandledException(true, falseMessage.replace("{permission}", permission));
        }
    }

    protected final void cancel(String ... messages) {
        throw new EventHandledException(true, messages);
    }

    protected final void cancel() {
        throw new EventHandledException(true, new String[0]);
    }

    protected final void returnTell(String ... messages) {
        throw new EventHandledException(false, messages);
    }

    public final void register() {
        Bukkit.getPluginManager().registerEvent(this.eventClass, (Listener)this, this.priority, (EventExecutor)this, (Plugin)SimplePlugin.getInstance(), this.ignoreCancelled);
    }

    public SimpleListener(Class<T> eventClass, EventPriority priority, boolean ignoreCancelled) {
        this.eventClass = eventClass;
        this.priority = priority;
        this.ignoreCancelled = ignoreCancelled;
    }
}

