/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MathUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.settings.SimpleSettings;

public final class LagCatcher {
    private static volatile Map<String, Long> startTimesMap = new HashMap<String, Long>();
    private static volatile Map<String, List<Long>> durationsMap = new HashMap<String, List<Long>>();

    public static void start(String section) {
        if (SimpleSettings.LAG_THRESHOLD_MILLIS == -1) {
            return;
        }
        startTimesMap.put(section, System.nanoTime());
    }

    public static void end(String section) {
        LagCatcher.end(section, false);
    }

    public static void end(String section, boolean rapid) {
        LagCatcher.end(section, rapid ? 0 : SimpleSettings.LAG_THRESHOLD_MILLIS, "{section} took {time} ms");
    }

    public static void end(String section, int thresholdMs, String message) {
        double lag = LagCatcher.finishAndCalculate(section);
        if (lag > (double)thresholdMs && SimpleSettings.LAG_THRESHOLD_MILLIS != -1) {
            message = message.replace("{section}", section);
            message = message.replace("{time}", MathUtil.formatTwoDigits(lag));
            if (SimplePlugin.hasInstance()) {
                Common.logNoPrefix("[{plugin_name} {plugin_version}] " + message);
            } else {
                System.out.println("[LagCatcher] " + message);
            }
        }
    }

    public static void performanceTest(int cycles, String name, Runnable code) {
        Valid.checkBoolean(cycles > 0, "Cycles must be above 0", new Object[0]);
        LagCatcher.start(name + "-whole");
        ArrayList<Double> lagMap = new ArrayList<Double>();
        for (int i = 0; i < cycles; ++i) {
            LagCatcher.start(name);
            code.run();
            lagMap.add(LagCatcher.finishAndCalculate(name));
        }
        System.out.println("Test '" + name + "' took " + MathUtil.formatTwoDigits(LagCatcher.finishAndCalculate(name + "-whole")) + " ms. Average " + MathUtil.average(lagMap) + " ms");
        if (!durationsMap.isEmpty()) {
            for (Map.Entry<String, List<Long>> entry : durationsMap.entrySet()) {
                String section = entry.getKey();
                long duration = 0L;
                for (long sectionDuration : entry.getValue()) {
                    duration += sectionDuration;
                }
                System.out.println("\tSection '" + section + "' took " + MathUtil.formatTwoDigits((double)duration / 1000000.0));
            }
            System.out.println("Section measurement ended.");
            durationsMap.clear();
        }
    }

    public static void performancePartStart(String section) {
        List<Long> sectionDurations = durationsMap.get(section);
        if (sectionDurations == null) {
            sectionDurations = new ArrayList<Long>();
            durationsMap.put(section, sectionDurations);
        }
        sectionDurations.add(System.nanoTime());
    }

    public static void performancePartSnap(String section) {
        Valid.checkBoolean(durationsMap.containsKey(section), "Section " + section + " is not measured! Are you calling it from performanceTest?", new Object[0]);
        List<Long> sectionDurations = durationsMap.get(section);
        int index = sectionDurations.size() - 1;
        long nanoTime = sectionDurations.get(index);
        long duration = System.nanoTime() - nanoTime;
        sectionDurations.set(index, duration);
    }

    private static double finishAndCalculate(String section) {
        Long nanoTime = startTimesMap.remove(section);
        return nanoTime == null ? 0.0 : (double)(System.nanoTime() - nanoTime) / 1000000.0;
    }

    private LagCatcher() {
    }
}

