/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.TimeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.settings.SimpleSettings;

public final class Debugger {
    private static final Map<String, ArrayList<String>> pendingMessages = new HashMap<String, ArrayList<String>>();
    private static boolean debugModeEnabled = false;

    public static void detectDebugMode() {
        if (new File(SimplePlugin.getData(), "debug.lock").exists()) {
            debugModeEnabled = true;
            System.out.println("Detected debug.lock file, debug features enabled!");
        } else {
            debugModeEnabled = false;
        }
    }

    public static void debug(String section, String ... messages) {
        if (Debugger.isDebugged(section)) {
            for (String message : messages) {
                if (SimplePlugin.hasInstance()) {
                    Common.log("[" + section + "] " + message);
                    continue;
                }
                System.out.println("[" + section + "] " + message);
            }
            if (SimplePlugin.hasInstance()) {
                Common.runAsync(() -> {
                    Map<String, ArrayList<String>> map = pendingMessages;
                    synchronized (map) {
                        for (String message : messages) {
                            FileUtil.writeFormatted("debug.log", "[" + section + "]", message);
                        }
                    }
                });
            }
        }
    }

    public static void put(String section, String message) {
        if (!Debugger.isDebugged(section)) {
            return;
        }
        ArrayList<String> list = pendingMessages.getOrDefault(section, new ArrayList());
        list.add(message);
        pendingMessages.put(section, list);
    }

    public static void push(String section, String message) {
        Debugger.put(section, message);
        Debugger.push(section);
    }

    public static void push(String section) {
        if (!Debugger.isDebugged(section)) {
            return;
        }
        List parts = pendingMessages.remove(section);
        Valid.checkNotNull(parts, "No messages to debug at section: " + section);
        String whole = StringUtils.join((Collection)parts, (String)"");
        for (String message : whole.split("\n")) {
            Debugger.debug(section, message);
        }
    }

    public static boolean isDebugged(String section) {
        return SimpleSettings.DEBUG_SECTIONS.contains(section) || SimpleSettings.DEBUG_SECTIONS.contains("*");
    }

    public static void saveError(Throwable t, String ... messages) {
        if (Bukkit.getServer() == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String header = SimplePlugin.getNamed() + " " + SimplePlugin.getVersion() + " encountered " + Common.article(t.getClass().getSimpleName());
        Debugger.fill(lines, "------------------------------------[ " + TimeUtil.getFormattedDate() + " ]-----------------------------------", header, "Running " + Bukkit.getName() + " " + Bukkit.getBukkitVersion() + " and Java " + System.getProperty("java.version"), "Plugins: " + StringUtils.join((Object[])Bukkit.getPluginManager().getPlugins(), (String)", "), "----------------------------------------------------------------------------------------------");
        if (messages != null && !StringUtils.join((Object[])messages, (String)"").isEmpty()) {
            Debugger.fill(lines, "\nMore Information: ");
            Debugger.fill(lines, messages);
        }
        block0: do {
            Debugger.fill(lines, t == null ? "Unknown error" : t.getClass().getSimpleName() + " " + Common.getOrDefault(t.getMessage(), Common.getOrDefault(t.getLocalizedMessage(), "(Unknown cause)")));
            int count = 0;
            for (StackTraceElement el : t.getStackTrace()) {
                String trace = el.toString();
                if (++count > 6 && trace.startsWith("net.minecraft.server")) continue block0;
                Debugger.fill(lines, "\t at " + el.toString());
            }
        } while ((t = t.getCause()) != null);
        Debugger.fill(lines, "----------------------------------------------------------------------------------------------", System.lineSeparator());
        Common.log(header + "! Please check your error.log and report this issue with the information in that file.");
        FileUtil.write("error.log", lines);
    }

    private static void fill(List<String> list, String ... messages) {
        list.addAll(Arrays.asList(messages));
    }

    public static List<String> traceRoute(boolean trackLineNumbers) {
        RuntimeException exception = new RuntimeException("I love horses");
        ArrayList<String> paths = new ArrayList<String>();
        for (StackTraceElement el : exception.getStackTrace()) {
            String[] classNames = el.getClassName().split("\\.");
            String className = classNames[classNames.length - 1];
            if (paths.contains(className)) continue;
            paths.add(className + (trackLineNumbers ? "#" + el.getLineNumber() : ""));
        }
        if (!paths.isEmpty()) {
            paths.remove(0);
        }
        return paths;
    }

    public static void printValues(Object[] values) {
        if (values != null) {
            Debugger.print(Common.consoleLine());
            Debugger.print("Enumeration of " + Common.plural(values.length, values.getClass().getSimpleName().toLowerCase().replace("[]", "")));
            for (int i = 0; i < values.length; ++i) {
                Debugger.print("&8[" + i + "] &7" + values[i]);
            }
        } else {
            Debugger.print("Value are null");
        }
    }

    public static void printStackTrace(String message) {
        StackTraceElement[] trace = new Exception().getStackTrace();
        Debugger.print("------------------------------------------------------------------------------------------------------------");
        Debugger.print(message);
        Debugger.print("");
        for (int i = 1; i < trace.length; ++i) {
            String line = trace[i].toString();
            if (!Debugger.canPrint(line)) continue;
            Debugger.print("\tat " + line);
        }
        Debugger.print("------------------------------------------------------------------------------------------------------------");
    }

    public static void printStackTrace(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        Debugger.print(throwable.toString());
        for (StackTraceElement element : throwable.getStackTrace()) {
            String line = element.toString();
            if (!Debugger.canPrint(line)) continue;
            Debugger.print("\tat " + line);
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            do {
                if (cause == null) continue;
                Debugger.printStackTrace(cause);
            } while ((cause = cause.getCause()) != null);
        }
    }

    private static boolean canPrint(String message) {
        return !message.contains("net.minecraft") && !message.contains("org.bukkit.craftbukkit") && !message.contains("nashorn") && !message.contains("javax.script");
    }

    private static void print(String message) {
        if (SimplePlugin.hasInstance()) {
            Common.logNoPrefix(message);
        } else {
            System.out.println(message);
        }
    }

    private Debugger() {
    }

    public static boolean isDebugModeEnabled() {
        return debugModeEnabled;
    }
}

