/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MathUtil;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.database.SimpleDatabase;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.debug.LagCatcher;
import org.mineacademy.fo.settings.SimpleSettings;

public abstract class SimpleFlatDatabase<T>
extends SimpleDatabase {
    private boolean isQuerying = false;

    @Override
    protected final void onConnected() {
        this.update("CREATE TABLE IF NOT EXISTS {table}(UUID varchar(64), Name text, Data text, Updated bigint)");
        this.removeOldEntries();
        this.onConnectFinish();
    }

    protected void onConnectFinish() {
    }

    private void removeOldEntries() {
        long threshold = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.getExpirationDays());
        this.update("DELETE FROM {table} WHERE Updated < " + threshold + "");
    }

    protected int getExpirationDays() {
        return 90;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(UUID uuid, T cache) {
        if (!this.isLoaded() || this.isQuerying) {
            return;
        }
        try {
            LagCatcher.start("mysql");
            this.isQuerying = true;
            Debugger.debug("mysql", "---------------- MySQL - Loading data for " + uuid);
            ResultSet resultSet = this.query("SELECT * FROM {table} WHERE UUID='" + uuid + "'");
            String dataRaw = resultSet.next() ? resultSet.getString("Data") : "{}";
            Debugger.debug("mysql", "JSON: " + dataRaw);
            SerializedMap data = SerializedMap.fromJson(dataRaw);
            Debugger.debug("mysql", "Deserialized data: " + data);
            this.onLoad(data, cache);
            resultSet.close();
        }
        catch (Throwable t) {
            Common.error(t, "Failed to load data from MySQL!", "UUID: " + uuid, "Error: %error");
        }
        finally {
            this.isQuerying = false;
            this.logPerformance("loading");
        }
    }

    protected abstract void onLoad(SerializedMap var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(String name, UUID uuid, T cache) {
        if (!this.isLoaded() || this.isQuerying) {
            return;
        }
        try {
            LagCatcher.start("mysql");
            this.isQuerying = true;
            SerializedMap data = this.onSave(cache);
            Debugger.debug("mysql", "---------------- MySQL - Saving data for " + uuid);
            Debugger.debug("mysql", "Raw data: " + data);
            Debugger.debug("mysql", "JSON: " + (data == null ? "null" : data.toJson()));
            if (data == null || data.isEmpty()) {
                this.update("DELETE FROM {table} WHERE UUID= '" + uuid + "';");
                if (Debugger.isDebugged("mysql")) {
                    Debugger.debug("mysql", "Data was empty, row has been removed.");
                }
            } else if (this.isStored(uuid)) {
                this.update("UPDATE {table} SET Data='" + data.toJson() + "', Updated='" + System.currentTimeMillis() + "' WHERE UUID='" + uuid + "';");
            } else {
                this.update("INSERT INTO {table}(UUID, Name, Data, Updated) VALUES ('" + uuid + "', '" + name + "', '" + data.toJson() + "', '" + System.currentTimeMillis() + "');");
            }
        }
        catch (Throwable ex) {
            Common.error(ex, "Failed to save data to MySQL!", "UUID: " + uuid, "Error: %error");
        }
        finally {
            this.isQuerying = false;
            this.logPerformance("saving");
        }
    }

    private void logPerformance(String operation) {
        boolean isMainThread = Bukkit.isPrimaryThread();
        LagCatcher.end("mysql", isMainThread ? 10 : MathUtil.atLeast(200, SimpleSettings.LAG_THRESHOLD_MILLIS), WordUtils.capitalize((String)operation) + " data to MySQL took {time} ms" + (isMainThread ? " - To prevent slowing the server, " + operation + " can be made async (carefully)" : ""));
    }

    private boolean isStored(@NonNull UUID uuid) throws SQLException {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        ResultSet resultSet = this.query("SELECT * FROM {table} WHERE UUID= '" + uuid.toString() + "'");
        if (resultSet == null) {
            return false;
        }
        if (resultSet.next()) {
            return resultSet.getString("UUID") != null;
        }
        return false;
    }

    protected abstract SerializedMap onSave(T var1);
}

