/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.debug.Debugger;

public class SimpleDatabase {
    private Connection connection;
    private LastCredentials lastCredentials;
    private final StrictMap<String, String> sqlVariables = new StrictMap();

    public final void connect(String host, int port, String database, String user, String password) {
        this.connect(host, port, database, user, password, null);
    }

    public final void connect(String host, int port, String database, String user, String password, String table) {
        this.connect(host, port, database, user, password, table, true);
    }

    public final void connect(String host, int port, String database, String user, String password, String table, boolean autoReconnect) {
        this.connect("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&autoReconnect=" + autoReconnect, user, password, table);
    }

    public final void connect(String url, String user, String password) {
        this.connect(url, user, password, null);
    }

    public final void connect(String url, String user, String password, String table) {
        this.lastCredentials = new LastCredentials(url, user, password, table);
        try {
            this.connection = DriverManager.getConnection(url, user, password);
            this.onConnected();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Common.logFramed(true, "Failed to connect to MySQL database", "URL: " + url, "Error: " + e.getMessage());
        }
    }

    private final void connectUsingLastCredentials() {
        if (this.lastCredentials != null) {
            this.connect(this.lastCredentials.url, this.lastCredentials.user, this.lastCredentials.password, this.lastCredentials.table);
        }
    }

    protected void onConnected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void close() {
        if (this.connection != null) {
            Connection connection = this.connection;
            synchronized (connection) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    Common.error(e, "Error closing MySQL connection!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void update(String sql) {
        this.checkEstablished();
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.isConnected()) {
                this.connectUsingLastCredentials();
            }
            Valid.checkBoolean(!(sql = this.replaceVariables(sql)).contains("{table}"), "Table not set! Either use connect() method that specifies it or call addVariable(table, 'yourtablename') in your constructor!", new Object[0]);
            Debugger.debug("mysql", "Updating MySQL with: " + sql);
            try {
                Statement statement = this.connection.createStatement();
                statement.executeUpdate(sql);
                statement.close();
            }
            catch (SQLException e) {
                Common.error(e, "Error on updating MySQL with: " + sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResultSet query(String sql) {
        this.checkEstablished();
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.isConnected()) {
                this.connectUsingLastCredentials();
            }
            sql = this.replaceVariables(sql);
            Debugger.debug("mysql", "Querying MySQL with: " + sql);
            try {
                Statement statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                return resultSet;
            }
            catch (SQLException e) {
                Common.error(e, "Error on querying MySQL with: " + sql);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkEstablished();
        Connection connection = this.connection;
        synchronized (connection) {
            if (!this.isConnected()) {
                this.connectUsingLastCredentials();
            }
            sql = this.replaceVariables(sql);
            Debugger.debug("mysql", "Preparing statement: " + sql);
            return this.connection.prepareStatement(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isConnected() {
        if (!this.isLoaded()) {
            return false;
        }
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                return this.connection != null && !this.connection.isClosed() && this.connection.isValid(0);
            }
            catch (SQLException ex) {
                return false;
            }
        }
    }

    protected final String getTable() {
        this.checkEstablished();
        return Common.getOrEmpty(this.lastCredentials.table);
    }

    private final void checkEstablished() {
        Valid.checkBoolean(this.isLoaded(), "Connection was never established", new Object[0]);
    }

    public final boolean isLoaded() {
        return this.connection != null;
    }

    protected final void addVariable(String name, String value) {
        this.sqlVariables.put(name, value);
    }

    private final String replaceVariables(String sql) {
        for (Map.Entry<String, String> entry : this.sqlVariables.entrySet()) {
            sql = sql.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return sql.replace("{table}", this.getTable());
    }

    protected Connection getConnection() {
        return this.connection;
    }

    private final class LastCredentials {
        private final String url;
        private final String user;
        private final String password;
        private final String table;

        public LastCredentials(String url, String user, String password, String table) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.table = table;
        }
    }
}

