/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.conversation;

import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.ValidatingPrompt;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.conversation.SimpleConversation;
import org.mineacademy.fo.conversation.SimplePrefix;
import org.mineacademy.fo.menu.Menu;

public abstract class SimplePrompt
extends ValidatingPrompt
implements Cloneable {
    private boolean openMenu = true;
    private Player player = null;

    protected SimplePrompt() {
    }

    protected SimplePrompt(boolean openMenu) {
        this.openMenu = openMenu;
    }

    protected String getCustomPrefix() {
        return null;
    }

    public final String getPromptText(ConversationContext ctx) {
        return Common.colorize(this.getPrompt(ctx));
    }

    protected abstract String getPrompt(ConversationContext var1);

    protected boolean isInputValid(ConversationContext context, String input) {
        return true;
    }

    protected String getFailedValidationText(ConversationContext context, String invalidInput) {
        return null;
    }

    protected Player getPlayer(ConversationContext ctx) {
        Valid.checkBoolean(ctx.getForWhom() instanceof Player, "Conversable is not a player but: " + ctx.getForWhom(), new Object[0]);
        return (Player)ctx.getForWhom();
    }

    protected void tell(String message) {
        Valid.checkNotNull(this.player, "Cannot use tell() when player not yet set!");
        this.tell((Conversable)this.player, message);
    }

    protected void tell(ConversationContext ctx, String message) {
        this.tell((Conversable)this.getPlayer(ctx), message);
    }

    protected void tell(Conversable conversable, String message) {
        Common.tellConversing(conversable, (this.getCustomPrefix() != null ? this.getCustomPrefix() : "") + message);
    }

    protected void tellLater(int delayTicks, Conversable conversable, String message) {
        Common.tellLaterConversing(delayTicks, conversable, (this.getCustomPrefix() != null ? this.getCustomPrefix() : "") + message);
    }

    public void onConversationEnd(SimpleConversation conversation, ConversationAbandonedEvent event) {
    }

    public final Prompt acceptInput(ConversationContext context, String input) {
        if (this.isInputValid(context, input)) {
            return this.acceptValidatedInput(context, input);
        }
        String failPrompt = this.getFailedValidationText(context, input);
        if (failPrompt != null) {
            this.tellLater(1, context.getForWhom(), "&c" + failPrompt);
        }
        return this;
    }

    public final SimpleConversation show(Player player) {
        Menu menu;
        Valid.checkBoolean(!player.isConversing(), "Player " + player.getName() + " is already conversing! Show them their next prompt in acceptValidatedInput() in " + this.getClass().getSimpleName() + " instead!", new Object[0]);
        this.player = player;
        SimpleConversation conversation = new SimpleConversation(){

            @Override
            protected Prompt getFirstPrompt() {
                return SimplePrompt.this;
            }

            @Override
            protected ConversationPrefix getPrefix() {
                String prefix = SimplePrompt.this.getCustomPrefix();
                return prefix != null ? new SimplePrefix(prefix) : super.getPrefix();
            }
        };
        if (this.openMenu && (menu = Menu.getMenu(player)) != null) {
            conversation.setMenuToReturnTo(menu);
        }
        conversation.start(player);
        return conversation;
    }

    public SimplePrompt clone() {
        return (SimplePrompt)super.clone();
    }

    public static final void show(Player player, SimplePrompt prompt) {
        prompt.show(player);
    }
}

