/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.conversation;

import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.expiringmap.ExpiringMap;
import org.mineacademy.fo.conversation.SimpleCanceller;
import org.mineacademy.fo.conversation.SimplePrefix;
import org.mineacademy.fo.conversation.SimplePrompt;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.model.BoxedMessage;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompSound;

public abstract class SimpleConversation
implements ConversationAbandonedListener {
    private Menu menuToReturnTo;

    protected SimpleConversation() {
        this(null);
    }

    protected SimpleConversation(Menu menuToReturnTo) {
        this.menuToReturnTo = menuToReturnTo;
    }

    public final void start(Player player) {
        Valid.checkBoolean(!player.isConversing(), "Player " + player.getName() + " is already conversing!", new Object[0]);
        player.closeInventory();
        CustomConversation conversation = new CustomConversation((Conversable)player);
        InactivityConversationCanceller inactivityCanceller = new InactivityConversationCanceller((Plugin)SimplePlugin.getInstance(), 45);
        inactivityCanceller.setConversation((Conversation)conversation);
        conversation.getCancellers().add(inactivityCanceller);
        conversation.getCancellers().add(this.getCanceller());
        conversation.addConversationAbandonedListener(this);
        conversation.begin();
    }

    protected abstract Prompt getFirstPrompt();

    public final void conversationAbandoned(ConversationAbandonedEvent event) {
        SimplePrompt lastPrompt;
        Conversable conversing = event.getContext().getForWhom();
        Object source = event.getSource();
        if (source instanceof CustomConversation && (lastPrompt = ((CustomConversation)((Object)source)).getLastSimplePrompt()) != null) {
            lastPrompt.onConversationEnd(this, event);
        }
        this.onConversationEnd(event);
        if (conversing instanceof Player) {
            Player player = (Player)conversing;
            (event.gracefulExit() ? CompSound.SUCCESSFUL_HIT : CompSound.NOTE_BASS).play(player, 1.0f, 1.0f);
            if (this.menuToReturnTo != null && this.reopenMenu()) {
                this.menuToReturnTo.newInstance().displayTo(player);
            }
        }
    }

    protected void onConversationEnd(ConversationAbandonedEvent event) {
    }

    protected ConversationPrefix getPrefix() {
        return new SimplePrefix(Common.ADD_TELL_PREFIX ? this.addLastSpace(Common.getTellPrefix()) : "");
    }

    private final String addLastSpace(String prefix) {
        return prefix.endsWith(" ") ? prefix : prefix + " ";
    }

    protected ConversationCanceller getCanceller() {
        return new SimpleCanceller("quit", "cancel", "exit");
    }

    protected boolean insertPrefix() {
        return true;
    }

    protected boolean reopenMenu() {
        return true;
    }

    protected int getTimeout() {
        return 60;
    }

    public void setMenuToReturnTo(Menu menu) {
        this.menuToReturnTo = menu;
    }

    protected static final void tellBoxed(int delayTicks, Conversable conversable, String ... messages) {
        Common.runLater(delayTicks, () -> SimpleConversation.tellBoxed(conversable, messages));
    }

    protected static final void tellBoxed(Conversable conversable, String ... messages) {
        BoxedMessage.tell((CommandSender)((Player)conversable), messages);
    }

    protected static final void tell(Conversable conversable, String message) {
        Common.tellConversing(conversable, message);
    }

    protected static final void tellLater(int delayTicks, Conversable conversable, String message) {
        Common.tellLaterConversing(delayTicks, conversable, message);
    }

    private final class CustomConversation
    extends Conversation {
        private SimplePrompt lastSimplePrompt;

        private CustomConversation(Conversable forWhom) {
            super((Plugin)SimplePlugin.getInstance(), forWhom, SimpleConversation.this.getFirstPrompt());
            this.localEchoEnabled = false;
            if (SimpleConversation.this.insertPrefix() && SimpleConversation.this.getPrefix() != null) {
                this.prefix = SimpleConversation.this.getPrefix();
            }
        }

        public void outputNextPrompt() {
            if (this.currentPrompt == null) {
                this.abandon(new ConversationAbandonedEvent((Conversation)this));
            } else {
                String promptClass = this.currentPrompt.getClass().getSimpleName();
                String question = this.currentPrompt.getPromptText(this.context);
                try {
                    ExpiringMap askedQuestions = this.context.getAllSessionData().getOrDefault("Asked_" + promptClass, ExpiringMap.builder().expiration(SimpleConversation.this.getTimeout(), TimeUnit.SECONDS).build());
                    if (!askedQuestions.containsKey(question)) {
                        askedQuestions.put(question, null);
                        this.context.setSessionData((Object)("Asked_" + promptClass), askedQuestions);
                        this.context.getForWhom().sendRawMessage(this.prefix.getPrefix(this.context) + question);
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                if (this.currentPrompt instanceof SimplePrompt) {
                    this.lastSimplePrompt = ((SimplePrompt)this.currentPrompt).clone();
                }
                if (!this.currentPrompt.blocksForInput(this.context)) {
                    this.currentPrompt = this.currentPrompt.acceptInput(this.context, null);
                    this.outputNextPrompt();
                }
            }
        }

        private SimplePrompt getLastSimplePrompt() {
            return this.lastSimplePrompt;
        }
    }
}

