/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.conversation;

import java.util.Arrays;
import java.util.List;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.mineacademy.fo.Valid;

public final class SimpleCanceller
implements ConversationCanceller {
    private final List<String> cancelPhrases;

    public SimpleCanceller(String ... cancelPhrases) {
        this(Arrays.asList(cancelPhrases));
    }

    public SimpleCanceller(List<String> cancelPhrases) {
        Valid.checkBoolean(!cancelPhrases.isEmpty(), "Cancel phrases are empty for conversation cancel listener!", new Object[0]);
        this.cancelPhrases = cancelPhrases;
    }

    public void setConversation(Conversation conversation) {
    }

    public boolean cancelBasedOnInput(ConversationContext context, String input) {
        for (String phrase : this.cancelPhrases) {
            if (!input.equalsIgnoreCase(phrase)) continue;
            return true;
        }
        return false;
    }

    public ConversationCanceller clone() {
        return new SimpleCanceller(this.cancelPhrases);
    }
}

