/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.command;

import java.util.Arrays;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.command.SimpleCommand;
import org.mineacademy.fo.command.SimpleCommandGroup;
import org.mineacademy.fo.plugin.SimplePlugin;

public abstract class SimpleSubCommand
extends SimpleCommand {
    private final String[] sublabels;
    private String sublabel;

    protected SimpleSubCommand(String sublabel) {
        this(SimpleSubCommand.getMainCommandGroup0(), sublabel);
    }

    private static SimpleCommandGroup getMainCommandGroup0() {
        SimpleCommandGroup main = SimplePlugin.getInstance().getMainCommand();
        Valid.checkNotNull(main, SimplePlugin.getNamed() + " does not define a main command group!");
        return main;
    }

    protected SimpleSubCommand(SimpleCommandGroup parent, String sublabel) {
        super(parent.getLabel());
        this.sublabels = sublabel.split("\\|");
        Valid.checkBoolean(this.sublabels.length > 0, "Please set at least 1 sublabel", new Object[0]);
        this.sublabel = this.sublabels[0];
        if (this.getRawPermission().equals("{plugin_name}.command.{label}")) {
            if (SimplePlugin.isMainCommand(this.getMainLabel())) {
                this.setPermission(this.getRawPermission().replace("{label}", "{sublabel}"));
            } else {
                this.setPermission(this.getRawPermission() + ".{sublabel}");
            }
        }
    }

    protected boolean showInHelp() {
        return true;
    }

    @Override
    protected String replacePlaceholders(String message) {
        return super.replacePlaceholders(message).replace("{sublabel}", this.getSublabel());
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof SimpleSubCommand ? Arrays.equals(((SimpleSubCommand)((Object)obj)).sublabels, this.sublabels) : false;
    }

    public String[] getSublabels() {
        return this.sublabels;
    }

    protected void setSublabel(String sublabel) {
        this.sublabel = sublabel;
    }

    protected String getSublabel() {
        return this.sublabel;
    }
}

