/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.RandomUtil;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.command.SimpleCommand;
import org.mineacademy.fo.command.SimpleSubCommand;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.settings.SimpleLocalization;

public abstract class SimpleCommandGroup {
    protected final StrictList<SimpleSubCommand> subcommands = new StrictList();
    protected SimpleCommand mainCommand;

    public final void register(StrictList<String> labelAndAliases) {
        this.register(labelAndAliases.get(0), (labelAndAliases.size() > 1 ? labelAndAliases.range(1) : new StrictList<String>()).getSource());
    }

    public final void register(String label, List<String> aliases) {
        Valid.checkBoolean(!this.isRegistered(), "Main command already registered as: " + (Object)((Object)this.mainCommand), new Object[0]);
        this.mainCommand = new MainCommand(label);
        if (aliases != null) {
            this.mainCommand.setAliases(aliases);
        }
        this.mainCommand.register();
        this.registerSubcommands();
    }

    public final void unregister() {
        Valid.checkBoolean(this.isRegistered(), "Main command not registered!", new Object[0]);
        this.mainCommand.unregister();
        this.mainCommand = null;
        this.subcommands.clear();
    }

    public final boolean isRegistered() {
        return this.mainCommand != null;
    }

    protected final <T extends SimpleSubCommand> void autoRegisterSubcommands(Class<T> ofClass) {
        for (Class<T> clazz : ReflectionUtil.getClasses((Plugin)SimplePlugin.getInstance(), ofClass)) {
            this.registerSubcommand((SimpleSubCommand)((Object)ReflectionUtil.instantiate(clazz)));
        }
    }

    protected abstract void registerSubcommands();

    protected final void registerSubcommand(SimpleSubCommand command) {
        Valid.checkNotNull((Object)this.mainCommand, "Cannot add subcommands when main command is missing! Call register()");
        Valid.checkBoolean(!this.subcommands.contains(command), "Subcommand /" + this.mainCommand.getLabel() + " " + command.getSublabel() + " already registered!", new Object[0]);
        this.subcommands.add(command);
    }

    protected final void registerHelpLine(String ... menuHelp) {
        Valid.checkNotNull((Object)this.mainCommand, "Cannot add subcommands when main command is missing! Call register()");
        this.subcommands.add(new FillerSubCommand(this, menuHelp));
    }

    public final String getLabel() {
        Valid.checkBoolean(this.isRegistered(), "Main command has not yet been set!", new Object[0]);
        return this.mainCommand.getMainLabel();
    }

    public final List<String> getAliases() {
        return this.mainCommand.getAliases();
    }

    protected String[] getNoParamsHeader(CommandSender sender) {
        String credits;
        int foundedYear = SimplePlugin.getInstance().getFoundedYear();
        int yearNow = Calendar.getInstance().get(1);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("&8" + Common.chatLine());
        messages.add(this.getHeaderPrefix() + "  " + SimplePlugin.getNamed() + this.getTrademark() + " &7" + SimplePlugin.getVersion());
        messages.add(" ");
        String authors = String.join((CharSequence)", ", SimplePlugin.getInstance().getDescription().getAuthors());
        if (!authors.isEmpty()) {
            messages.add("   &7" + SimpleLocalization.Commands.LABEL_AUTHORS + " &f" + authors + (foundedYear != -1 ? " &7\u00a9 " + foundedYear + (yearNow != foundedYear ? " - " + yearNow : "") : ""));
        }
        if ((credits = this.getCredits()) != null && !credits.isEmpty()) {
            messages.add("   " + credits);
        }
        messages.add("&8" + Common.chatLine());
        return messages.toArray(new String[messages.size()]);
    }

    protected boolean sendHelpIfNoArgs() {
        return false;
    }

    private String getTrademark() {
        return SimplePlugin.getInstance().getDescription().getAuthors().contains("kangarko") ? this.getHeaderPrefix() + "&8\u2122" : "";
    }

    protected String getCredits() {
        return "&7Visit &fmineacademy.org &7for more information.";
    }

    protected List<String> getHelpLabel() {
        return Arrays.asList("help", "?");
    }

    protected String[] getHelpHeader() {
        return new String[]{"&8", "&8" + Common.chatLine(), this.getHeaderPrefix() + "  " + SimplePlugin.getNamed() + this.getTrademark() + " &7" + SimplePlugin.getVersion(), " ", "&2  [] &f= " + SimpleLocalization.Commands.LABEL_OPTIONAL_ARGS, "&6  <> &f= " + SimpleLocalization.Commands.LABEL_REQUIRED_ARGS, " "};
    }

    protected String getHeaderPrefix() {
        return "" + ChatColor.GOLD + ChatColor.BOLD;
    }

    protected SimpleCommandGroup() {
    }

    private final class FillerSubCommand
    extends SimpleSubCommand {
        private final String[] helpMessages;

        private FillerSubCommand(SimpleCommandGroup parent, String ... menuHelp) {
            super(parent, "_" + RandomUtil.nextBetween(1, Short.MAX_VALUE));
            this.helpMessages = menuHelp;
        }

        @Override
        protected void onCommand() {
            throw new FoException("Filler space command cannot be run!");
        }

        public String[] getHelpMessages() {
            return this.helpMessages;
        }
    }

    public final class MainCommand
    extends SimpleCommand {
        private MainCommand(String label) {
            super(label);
            this.setPermission(null);
            this.setAutoHandleHelp(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCommand() {
            if (this.args.length == 0) {
                if (SimpleCommandGroup.this.sendHelpIfNoArgs()) {
                    this.tellSubcommandsHelp();
                } else {
                    this.tell(SimpleCommandGroup.this.getNoParamsHeader(this.sender));
                }
                return;
            }
            String argument = this.args[0];
            SimpleSubCommand command = this.findSubcommand(argument);
            if (command != null) {
                String oldSublabel = command.getSublabel();
                try {
                    command.setSublabel(this.args[0]);
                    command.execute(this.sender, this.getLabel(), this.args.length == 1 ? new String[]{} : Arrays.copyOfRange(this.args, 1, this.args.length));
                }
                finally {
                    command.setSublabel(oldSublabel);
                }
            } else if (!SimpleCommandGroup.this.getHelpLabel().isEmpty() && Valid.isInList(argument, SimpleCommandGroup.this.getHelpLabel())) {
                this.tellSubcommandsHelp();
            } else {
                this.returnInvalidArgs();
            }
        }

        protected void tellSubcommandsHelp() {
            this.tell(SimpleCommandGroup.this.getHelpHeader());
            if (SimpleCommandGroup.this.subcommands.isEmpty()) {
                return;
            }
            Integer shown = 0;
            for (SimpleSubCommand subcommand : SimpleCommandGroup.this.subcommands) {
                if (!subcommand.showInHelp() || !this.hasPerm(subcommand.getPermission())) continue;
                if (subcommand instanceof FillerSubCommand) {
                    this.tellNoPrefix(((FillerSubCommand)subcommand).getHelpMessages());
                    continue;
                }
                String usage = this.colorizeUsage(subcommand.getUsage());
                String desc = Common.getOrEmpty(subcommand.getDescription());
                this.tellNoPrefix(" &f/" + this.getLabel() + " " + subcommand.getSublabel() + " " + (usage.isEmpty() ? "" : usage + " ") + (!desc.isEmpty() ? "&e- " + desc : ""));
                Integer n = shown;
                Integer n2 = shown = Integer.valueOf(shown + 1);
            }
            if (shown == 0) {
                this.tellNoPrefix(SimpleLocalization.Commands.HEADER_NO_SUBCOMMANDS);
            }
        }

        private String colorizeUsage(String message) {
            return message == null ? "" : message.replace("<", "&6<").replace(">", "&6>&f").replace("[", "&2[").replace("]", "&2]&f");
        }

        private SimpleSubCommand findSubcommand(String label) {
            for (SimpleSubCommand command : SimpleCommandGroup.this.subcommands) {
                if (command instanceof FillerSubCommand) continue;
                for (String alias : command.getSublabels()) {
                    if (!alias.equalsIgnoreCase(label)) continue;
                    return command;
                }
            }
            return null;
        }

        @Override
        public List<String> tabComplete() {
            SimpleSubCommand cmd;
            if (this.args.length == 1) {
                return this.tabCompleteSubcommands(this.sender, this.args[0]);
            }
            if (this.args.length > 1 && (cmd = this.findSubcommand(this.args[0])) != null) {
                return cmd.tabComplete(this.sender, this.getLabel(), Arrays.copyOfRange(this.args, 1, this.args.length));
            }
            return null;
        }

        private List<String> tabCompleteSubcommands(CommandSender sender, String param) {
            param = param.toLowerCase();
            ArrayList<String> tab = new ArrayList<String>();
            for (SimpleSubCommand subcommand : SimpleCommandGroup.this.subcommands) {
                if (subcommand instanceof FillerSubCommand || !this.hasPerm(subcommand.getPermission())) continue;
                for (String label : subcommand.getSublabels()) {
                    if (label.trim().isEmpty() || !label.startsWith(param)) continue;
                    tab.add(label);
                }
            }
            return tab;
        }
    }
}

