/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Messenger;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.TabUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.collection.expiringmap.ExpiringMap;
import org.mineacademy.fo.command.SimpleSubCommand;
import org.mineacademy.fo.exception.CommandException;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.exception.InvalidCommandArgException;
import org.mineacademy.fo.model.Replacer;
import org.mineacademy.fo.model.SimpleComponent;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.SimpleLocalization;

public abstract class SimpleCommand
extends Command {
    protected static final String DEFAULT_PERMISSION_SYNTAX = "{plugin_name}.command.{label}";
    public static boolean USE_MESSENGER = false;
    private final ExpiringMap<UUID, Long> cooldownMap = ExpiringMap.builder().expiration(30L, TimeUnit.MINUTES).build();
    private String label;
    private boolean registered = false;
    private boolean addTellPrefix = true;
    private String tellPrefix = "";
    private int minArguments = 0;
    private int cooldownSeconds = 0;
    private String cooldownMessage = null;
    private boolean autoHandleHelp = true;
    protected CommandSender sender;
    protected String[] args;

    protected SimpleCommand(String label) {
        this(SimpleCommand.parseLabel0(label), SimpleCommand.parseAliases0(label));
    }

    protected SimpleCommand(StrictList<String> labels) {
        this(SimpleCommand.parseLabelList0(labels), labels.size() > 1 ? labels.subList(1, labels.size()) : null);
    }

    protected SimpleCommand(String label, List<String> aliases) {
        super(label);
        Valid.checkBoolean(!(this instanceof CommandExecutor), "Please do not write 'implements CommandExecutor' for /" + super.getLabel() + " cmd, we already have a listener there", new Object[0]);
        Valid.checkBoolean(!(this instanceof TabCompleter), "Please do not write 'implements TabCompleter' for /" + super.getLabel() + " cmd, simply override tabComplete method", new Object[0]);
        this.setLabel(label);
        if (aliases != null) {
            this.setAliases(aliases);
        }
        this.setPermission(DEFAULT_PERMISSION_SYNTAX);
    }

    private static String parseLabel0(String label) {
        Valid.checkNotNull(label, "Label must not be null!");
        return label.split("\\|")[0];
    }

    private static List<String> parseAliases0(String label) {
        String[] aliases = label.split("\\|");
        return aliases.length > 0 ? Arrays.asList(Arrays.copyOfRange(aliases, 1, aliases.length)) : new ArrayList<String>();
    }

    private static String parseLabelList0(StrictList<String> labels) {
        Valid.checkBoolean(!labels.isEmpty(), "Command label must not be empty!", new Object[0]);
        return labels.get(0);
    }

    public final void register() {
        this.register(true);
    }

    public final void register(boolean unregisterOldAliases) {
        Valid.checkBoolean(!(this instanceof SimpleSubCommand), "Sub commands cannot be registered!", new Object[0]);
        Valid.checkBoolean(!this.registered, "The command /" + this.getLabel() + " has already been registered!", new Object[0]);
        PluginCommand oldCommand = Bukkit.getPluginCommand((String)this.getLabel());
        if (oldCommand != null) {
            String owningPlugin = oldCommand.getPlugin().getName();
            if (!owningPlugin.equals(SimplePlugin.getNamed())) {
                Common.log("&eCommand &f/" + this.getLabel() + " &ealready used by " + owningPlugin + ", we take it over...");
            }
            Remain.unregisterCommand(oldCommand.getLabel(), unregisterOldAliases);
        }
        Remain.registerCommand(this);
        this.registered = true;
    }

    public final void unregister() {
        Valid.checkBoolean(!(this instanceof SimpleSubCommand), "Sub commands cannot be unregistered!", new Object[0]);
        Valid.checkBoolean(this.registered, "The command /" + this.getLabel() + " is not registered!", new Object[0]);
        Remain.unregisterCommand(this.getLabel());
        this.registered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute(CommandSender sender, String label, String[] args) {
        if (SimplePlugin.isReloading() || !SimplePlugin.getInstance().isEnabled()) {
            Common.tell(sender, SimpleLocalization.Commands.USE_WHILE_NULL.replace("{state}", SimplePlugin.isReloading() ? SimpleLocalization.Commands.RELOADING : SimpleLocalization.Commands.DISABLED));
            return false;
        }
        this.sender = sender;
        this.label = label;
        this.args = args;
        boolean hadTellPrefix = Common.ADD_TELL_PREFIX;
        if (hadTellPrefix) {
            Common.ADD_TELL_PREFIX = this.addTellPrefix;
        }
        try {
            if (this.getPermission() != null) {
                this.checkPerm(this.getPermission());
            }
            if (args.length < this.getMinArguments() || this.autoHandleHelp && args.length == 1 && ("help".equals(args[0]) || "?".equals(args[0]))) {
                if (Common.getOrEmpty(this.getUsage()).isEmpty()) {
                    throw new FoException("If you set getMinArguments you must also call setUsage for /" + this.getLabel() + " command!");
                }
                if (!Common.getOrEmpty(this.getDescription()).isEmpty()) {
                    this.tellNoPrefix(SimpleLocalization.Commands.LABEL_DESCRIPTION.replace("{description}", this.getDescription()));
                }
                if (this.getMultilineUsageMessage() != null) {
                    this.tellNoPrefix(SimpleLocalization.Commands.LABEL_USAGES);
                    this.tellNoPrefix(this.getMultilineUsageMessage());
                } else if (this.getMultilineUsageMessage() != null) {
                    this.tellNoPrefix(SimpleLocalization.Commands.LABEL_USAGES);
                    this.tellNoPrefix(this.getMultilineUsageMessage());
                } else {
                    String sublabel = this instanceof SimpleSubCommand ? " " + ((SimpleSubCommand)this).getSublabel() : "";
                    this.tellNoPrefix(SimpleLocalization.Commands.LABEL_USAGE + " /" + label + sublabel + (!this.getUsage().startsWith("/") ? " " + Common.stripColors(this.getUsage()) : ""));
                }
                boolean sublabel = true;
                return sublabel;
            }
            if (this.cooldownSeconds > 0) {
                this.handleCooldown();
            }
            this.onCommand();
        }
        catch (InvalidCommandArgException ex) {
            if (this.getMultilineUsageMessage() == null) {
                this.dynamicTellError(ex.getMessage() != null ? ex.getMessage() : SimpleLocalization.Commands.INVALID_SUB_ARGUMENT);
            } else {
                this.dynamicTellError(SimpleLocalization.Commands.INVALID_ARGUMENT_MULTILINE);
                this.tellNoPrefix(this.getMultilineUsageMessage());
            }
        }
        catch (CommandException ex) {
            if (ex.getMessages() != null) {
                this.dynamicTellError(ex.getMessages());
            }
        }
        catch (Throwable t) {
            this.dynamicTellError(SimpleLocalization.Commands.ERROR.replace("{error}", t.toString()));
            String sublabel = this instanceof SimpleSubCommand ? " " + ((SimpleSubCommand)this).getSublabel() : "";
            Common.error(t, "Failed to execute command /" + this.getLabel() + sublabel + " " + String.join((CharSequence)" ", args));
        }
        finally {
            Common.ADD_TELL_PREFIX = hadTellPrefix;
        }
        return true;
    }

    private void dynamicTellError(String ... messages) {
        if (USE_MESSENGER) {
            for (String message : messages) {
                this.tellError(message);
            }
        } else {
            this.tell(messages);
        }
    }

    private void handleCooldown() {
        if (this.isPlayer()) {
            Player player = this.getPlayer();
            long lastExecution = this.cooldownMap.getOrDefault(player.getUniqueId(), 0L);
            long lastExecutionDifference = (System.currentTimeMillis() - lastExecution) / 1000L;
            this.checkBoolean(lastExecution == 0L || lastExecutionDifference > (long)this.cooldownSeconds, Common.getOrDefault(this.cooldownMessage, SimpleLocalization.Commands.COOLDOWN_WAIT).replace("{duration}", (long)this.cooldownSeconds - lastExecutionDifference + 1L + ""));
            this.cooldownMap.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    protected abstract void onCommand();

    protected String[] getMultilineUsageMessage() {
        return null;
    }

    protected final void checkConsole() throws CommandException {
        if (!this.isPlayer()) {
            throw new CommandException(new String[]{"&c" + SimpleLocalization.Commands.NO_CONSOLE});
        }
    }

    public final void checkPerm(@NonNull String perm) throws CommandException {
        if (perm == null) {
            throw new NullPointerException("perm is marked non-null but is null");
        }
        if (this.isPlayer() && !PlayerUtil.hasPerm((Permissible)this.sender, perm)) {
            throw new CommandException(new String[]{this.getPermissionMessage().replace("{permission}", perm)});
        }
    }

    protected final void checkArgs(int minimumLength, String falseMessage) throws CommandException {
        if (this.args.length < minimumLength) {
            this.returnTell((USE_MESSENGER ? "" : "&c") + falseMessage);
        }
    }

    protected final void checkBoolean(boolean value, String falseMessage) throws CommandException {
        if (!value) {
            this.returnTell((USE_MESSENGER ? "" : "&c") + falseMessage);
        }
    }

    protected final void checkNotNull(Object value, String messageIfNull) throws CommandException {
        if (value == null) {
            this.returnTell((USE_MESSENGER ? "" : "&c") + messageIfNull);
        }
    }

    protected final Player findPlayer(String name) throws CommandException {
        return this.findPlayer(name, SimpleLocalization.Player.NOT_ONLINE);
    }

    protected final Player findPlayer(String name, String falseMessage) throws CommandException {
        Player player = PlayerUtil.getPlayerByNickNoVanish(name);
        this.checkBoolean(player != null && player.isOnline(), falseMessage.replace("{player}", name));
        return player;
    }

    protected final CompMaterial findMaterial(String name, String falseMessage) throws CommandException {
        CompMaterial found = CompMaterial.fromString(name);
        this.checkNotNull((Object)found, falseMessage.replace("{enum}", name).replace("{item}", name));
        return found;
    }

    protected final <T extends Enum<T>> T findEnum(Class<T> enumType, String name, String falseMessage) throws CommandException {
        T found = null;
        try {
            found = ReflectionUtil.lookupEnum(enumType, name);
        }
        catch (ReflectionUtil.MissingEnumException missingEnumException) {
            // empty catch block
        }
        this.checkNotNull(found, falseMessage.replace("{enum}", name));
        return found;
    }

    protected final int findNumber(int index, int min, int max, String falseMessage) {
        return this.findNumber(Integer.class, index, min, max, falseMessage);
    }

    protected final int findNumber(int index, String falseMessage) {
        return this.findNumber(Integer.class, index, falseMessage);
    }

    protected final <T extends Number> T findNumber(Class<T> numberType, int index, T min, T max, String falseMessage) {
        T number = this.findNumber(numberType, index, falseMessage);
        this.checkBoolean(((Comparable)number).compareTo(min) >= 0 && ((Comparable)number).compareTo(max) <= 0, falseMessage.replace("{min}", min + "").replace("{max}", max + ""));
        return number;
    }

    protected final <T extends Number> T findNumber(Class<T> numberType, int index, String falseMessage) {
        block3: {
            this.checkBoolean(index < this.args.length, falseMessage);
            try {
                return (T)((Number)numberType.getMethod("valueOf", String.class).invoke(null, this.args[index]));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NumberFormatException) break block3;
                e.printStackTrace();
            }
        }
        throw new CommandException(new String[]{this.replacePlaceholders((USE_MESSENGER ? "" : "&c") + falseMessage)});
    }

    protected final boolean findBoolean(int index, String invalidMessage) {
        this.checkBoolean(index < this.args.length, invalidMessage);
        if (this.args[index].equalsIgnoreCase("true")) {
            return true;
        }
        if (this.args[index].equalsIgnoreCase("false")) {
            return false;
        }
        throw new CommandException(new String[]{this.replacePlaceholders((USE_MESSENGER ? "" : "&c") + invalidMessage)});
    }

    protected final boolean hasPerm(String permission) {
        return PlayerUtil.hasPerm((Permissible)this.sender, permission);
    }

    protected final void tell(SimpleComponent component) {
        component.send(new CommandSender[]{this.sender});
    }

    protected final void tell(Replacer replacer) {
        this.tell(replacer.getReplacedMessage());
    }

    protected final void tell(Collection<String> messages) {
        this.tell(messages.toArray(new String[messages.size()]));
    }

    protected final void tellNoPrefix(Replacer replacer) {
        this.tellNoPrefix(replacer.getReplacedMessage());
    }

    protected final void tellNoPrefix(String ... messages) {
        boolean tellPrefix = Common.ADD_TELL_PREFIX;
        boolean localPrefix = this.addTellPrefix;
        Common.ADD_TELL_PREFIX = false;
        this.addTellPrefix = false;
        this.tell(messages);
        Common.ADD_TELL_PREFIX = tellPrefix;
        this.addTellPrefix = localPrefix;
    }

    protected final void tell(String ... messages) {
        block4: {
            block5: {
                block6: {
                    if (messages == null) break block4;
                    messages = this.replacePlaceholders(messages);
                    if (this.addTellPrefix && !USE_MESSENGER && messages.length <= 2) break block5;
                    if (!USE_MESSENGER || !this.addTellPrefix) break block6;
                    this.tellInfo(messages[0]);
                    if (messages.length <= 1) break block4;
                    for (int i = 1; i < messages.length; ++i) {
                        Common.tellNoPrefix(this.sender, messages[i]);
                    }
                    break block4;
                }
                Common.tellNoPrefix(this.sender, messages);
                break block4;
            }
            if (this.tellPrefix.isEmpty()) {
                Common.tell(this.sender, messages);
            } else {
                for (String message : messages) {
                    Common.tellNoPrefix(this.sender, (this.tellPrefix.isEmpty() ? "" : this.tellPrefix + " ") + message);
                }
            }
        }
    }

    protected final void tellSuccess(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.success(this.sender, message);
        }
    }

    protected final void tellInfo(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.info(this.sender, message);
        }
    }

    protected final void tellWarn(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.warn(this.sender, message);
        }
    }

    protected final void tellError(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.error(this.sender, message);
        }
    }

    protected final void tellQuestion(String message) {
        if (message != null) {
            message = this.replacePlaceholders(message);
            Messenger.question(this.sender, message);
        }
    }

    protected final void returnInvalidArgs() {
        this.returnTell(SimpleLocalization.Commands.INVALID_ARGUMENT.replace("{label}", this.getLabel()));
    }

    protected final void returnTell(Collection<String> messages) throws CommandException {
        this.returnTell(messages.toArray(new String[messages.size()]));
    }

    protected final void returnTell(Replacer replacer) throws CommandException {
        this.returnTell(replacer.getReplacedMessage());
    }

    protected final void returnTell(String ... messages) throws CommandException {
        throw new CommandException(this.replacePlaceholders(messages));
    }

    protected final String[] replacePlaceholders(String[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = this.replacePlaceholders(messages[i]).replace("{prefix}", Common.getTellPrefix());
        }
        return messages;
    }

    protected String replacePlaceholders(String message) {
        message = this.replaceBasicPlaceholders0(message);
        for (int i = 0; i < this.args.length; ++i) {
            message = message.replace("{" + i + "}", Common.getOrEmpty(this.args[i]));
        }
        return message;
    }

    private String replaceBasicPlaceholders0(String message) {
        return message.replace("{label}", this.getLabel()).replace("{sublabel}", this instanceof SimpleSubCommand ? ((SimpleSubCommand)this).getSublabels()[0] : super.getLabel()).replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase());
    }

    protected final void setArg(int position, String value) {
        if (this.args.length <= position) {
            this.args = Arrays.copyOf(this.args, position + 1);
        }
        this.args[position] = value;
    }

    protected final String getLastArg() {
        return this.args.length > 0 ? this.args[this.args.length - 1] : "";
    }

    protected final String[] rangeArgs(int from) {
        return this.rangeArgs(from, this.args.length);
    }

    protected final String[] rangeArgs(int from, int to) {
        return Arrays.copyOfRange(this.args, from, to);
    }

    protected final String joinArgs(int from) {
        return this.joinArgs(from, this.args.length);
    }

    protected final String joinArgs(int from, int to) {
        String message = "";
        for (int i = from; i < this.args.length && i < to; ++i) {
            message = message + this.args[i] + (i + 1 == this.args.length ? "" : " ");
        }
        return message;
    }

    @Deprecated
    public final List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        return this.tabComplete(sender, alias, args);
    }

    public final List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        this.sender = sender;
        this.label = alias;
        this.args = args;
        if (this.hasPerm(this.getPermission())) {
            List<String> suggestions = this.tabComplete();
            if (suggestions == null) {
                suggestions = this.completeLastWordPlayerNames();
            }
            return suggestions;
        }
        return new ArrayList<String>();
    }

    protected List<String> tabComplete() {
        return null;
    }

    protected final <T> List<String> completeLastWord(T ... suggestions) {
        return TabUtil.complete(this.getLastArg(), suggestions);
    }

    protected final <T> List<String> completeLastWord(Iterable<T> suggestions) {
        ArrayList<T> list = new ArrayList<T>();
        for (T suggestion : suggestions) {
            list.add(suggestion);
        }
        return TabUtil.complete(this.getLastArg(), list.toArray());
    }

    protected final List<String> completeLastWordPlayerNames() {
        return TabUtil.complete(this.getLastArg(), this.isPlayer() ? Common.getPlayerNames(false) : Common.getPlayerNames());
    }

    protected final Player getPlayer() {
        return this.isPlayer() ? (Player)this.getSender() : null;
    }

    protected final boolean isPlayer() {
        return this.sender instanceof Player;
    }

    protected final void addTellPrefix(boolean addTellPrefix) {
        this.addTellPrefix = addTellPrefix;
    }

    protected final void setTellPrefix(String tellPrefix) {
        this.tellPrefix = tellPrefix;
    }

    protected final void setMinArguments(int minArguments) {
        Valid.checkBoolean(minArguments >= 0, "Minimum arguments must be 0 or greater", new Object[0]);
        this.minArguments = minArguments;
    }

    protected final void setCooldown(int cooldown, TimeUnit unit) {
        Valid.checkBoolean(cooldown >= 0, "Cooldown must be >= 0 for /" + this.getLabel(), new Object[0]);
        this.cooldownSeconds = (int)unit.toSeconds(cooldown);
    }

    protected final void setCooldownMessage(String cooldownMessage) {
        this.cooldownMessage = cooldownMessage;
    }

    public final String getPermissionMessage() {
        return Common.getOrDefault(super.getPermissionMessage(), "&c" + SimpleLocalization.NO_PERMISSION);
    }

    public final String getPermission() {
        return super.getPermission() == null ? null : this.replaceBasicPlaceholders0(super.getPermission());
    }

    @Deprecated
    protected final String getRawPermission() {
        return super.getPermission();
    }

    public final void setPermission(String permission) {
        super.setPermission(permission);
    }

    protected final CommandSender getSender() {
        Valid.checkNotNull(this.sender, "Sender cannot be null");
        return this.sender;
    }

    protected final String getUsageError() {
        String sublabel = this instanceof SimpleSubCommand ? " " + ((SimpleSubCommand)this).getSublabel() : "";
        return SimpleLocalization.Commands.LABEL_USAGE + " /" + this.label + sublabel + (!this.getUsage().startsWith("/") ? " " + Common.stripColors(this.getUsage()) : "");
    }

    public final List<String> getAliases() {
        return super.getAliases();
    }

    public final String getDescription() {
        return super.getDescription();
    }

    public final String getName() {
        return super.getName();
    }

    public final String getUsage() {
        String bukkitUsage = super.getUsage();
        return bukkitUsage.equals("/" + this.getMainLabel()) ? "" : bukkitUsage;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getMainLabel() {
        return super.getLabel();
    }

    public final boolean setLabel(String label) {
        this.label = label;
        return super.setLabel(label);
    }

    protected final void setAutoHandleHelp(boolean autoHandleHelp) {
        this.autoHandleHelp = autoHandleHelp;
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleCommand ? ((SimpleCommand)((Object)obj)).getLabel().equals(this.getLabel()) && ((SimpleCommand)((Object)obj)).getAliases().equals(this.getAliases()) : false;
    }

    public final String toString() {
        return "Command{label=/" + this.label + "}";
    }

    public int getMinArguments() {
        return this.minArguments;
    }
}

