/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictCollection;
import org.mineacademy.fo.exception.FoException;

public final class StrictSet<E>
extends StrictCollection
implements Iterable<E> {
    private final Set<E> set = new HashSet();

    @SafeVarargs
    public StrictSet(E ... elements) {
        this();
        this.addAll(Arrays.asList(elements));
    }

    public StrictSet(Collection<E> oldList) {
        this();
        this.addAll(oldList);
    }

    public StrictSet() {
        super("Cannot remove '%s' as it is not in the set!", "Value '%s' is already in the set!");
    }

    public void remove(E value) {
        Valid.checkNotNull(value, "Cannot remove null values");
        boolean removed = this.set.remove(value);
        Valid.checkBoolean(removed, String.format(this.getCannotRemoveMessage(), value), new Object[0]);
    }

    public void addAll(Collection<E> collection) {
        for (E val : collection) {
            this.add(val);
        }
    }

    public void add(E key) {
        Valid.checkNotNull(key, "Cannot add null values");
        Valid.checkBoolean(!this.set.contains(key), String.format(this.getCannotAddMessage(), key), new Object[0]);
        this.set.add(key);
    }

    public E getAt(int index) {
        int i = 0;
        for (E e : this.set) {
            if (i++ != index) continue;
            return e;
        }
        throw new FoException("Index (" + index + ") + out of size (" + this.set.size() + ")");
    }

    public boolean contains(E key) {
        return this.set.contains(key);
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    public Set<E> getSource() {
        return this.set;
    }

    public String join(String separator) {
        return StringUtils.join(this.set, (String)separator);
    }

    public E[] toArray(E[] e) {
        return this.set.toArray(e);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object serialize() {
        return SerializeUtil.serialize(this.set);
    }

    public String toString() {
        return "StrictSet{\n" + StringUtils.join(this.set, (String)"\n") + "}";
    }
}

