/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictCollection;

public final class StrictMap<E, T>
extends StrictCollection {
    private final Map<E, T> map = new LinkedHashMap<E, T>();

    public StrictMap() {
        super("Cannot remove '%s' as it is not in the map!", "Key '%s' is already in the map --> '%s'");
    }

    public StrictMap(String removeMessage, String addMessage) {
        super(removeMessage, addMessage);
    }

    public StrictMap(Map<E, T> copyOf) {
        this();
        this.putAll(copyOf);
    }

    public void removeByValue(T value) {
        for (Map.Entry<E, T> e : this.map.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            this.map.remove(e.getKey());
            return;
        }
        throw new NullPointerException(String.format(this.getCannotRemoveMessage(), value));
    }

    public Object[] removeAll(Collection<E> keys) {
        ArrayList<T> removedKeys = new ArrayList<T>();
        for (E key : keys) {
            removedKeys.add(this.remove(key));
        }
        return removedKeys.toArray();
    }

    public T remove(E key) {
        T removed = this.removeWeak(key);
        Valid.checkNotNull(removed, String.format(this.getCannotRemoveMessage(), key));
        return removed;
    }

    public void put(E key, T value) {
        Valid.checkBoolean(!this.map.containsKey(key), String.format(this.getCannotAddMessage(), key, this.map.get(key)), new Object[0]);
        this.override(key, value);
    }

    public void putAll(Map<? extends E, ? extends T> m) {
        for (Map.Entry<E, T> e : m.entrySet()) {
            Valid.checkBoolean(!this.map.containsKey(e.getKey()), String.format(this.getCannotAddMessage(), e.getKey(), this.map.get(e.getKey())), new Object[0]);
        }
        this.override(m);
    }

    public T removeWeak(E value) {
        return this.map.remove(value);
    }

    public void override(E key, T value) {
        this.map.put(key, value);
    }

    public void override(Map<? extends E, ? extends T> m) {
        this.map.putAll(m);
    }

    public T getOrPut(E key, T defaultToPut) {
        if (this.contains(key)) {
            return this.get(key);
        }
        this.put(key, defaultToPut);
        return defaultToPut;
    }

    public E getKeyFromValue(T value) {
        for (Map.Entry<E, T> e : this.map.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            return e.getKey();
        }
        return null;
    }

    public E getFirstKey() {
        return this.map.isEmpty() ? null : (E)this.map.keySet().iterator().next();
    }

    public T get(E key) {
        return this.map.get(key);
    }

    public T getOrDefault(E key, T def) {
        return this.map.getOrDefault(key, def);
    }

    public boolean contains(E key) {
        return key == null ? false : this.map.containsKey(key);
    }

    public boolean containsValue(T value) {
        return value == null ? false : this.map.containsValue(value);
    }

    public void forEachIterate(BiConsumer<E, T> consumer) {
        for (Map.Entry<E, T> entry : this.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public Set<Map.Entry<E, T>> entrySet() {
        return this.map.entrySet();
    }

    public Set<E> keySet() {
        return this.map.keySet();
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<E, T> getSource() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Object serialize() {
        if (!this.map.isEmpty()) {
            HashMap<Object, Object> copy = new HashMap<Object, Object>();
            for (Map.Entry<E, T> e : this.entrySet()) {
                T val = e.getValue();
                if (val == null) continue;
                copy.put(SerializeUtil.serialize(e.getKey()), SerializeUtil.serialize(val));
            }
            return copy;
        }
        return this.getSource();
    }

    public String toString() {
        return this.map.toString();
    }
}

