/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.collection;

import com.google.gson.Gson;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.MemorySection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictCollection;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.model.Tuple;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;

public final class SerializedMap
extends StrictCollection {
    private static final Gson gson = new Gson();
    private final StrictMap<String, Object> map = new StrictMap();

    private SerializedMap(String key, Object value) {
        this();
        this.put(key, value);
    }

    public SerializedMap() {
        super("Cannot remove '%s' as it is not in the map!", "Value '%s' is already in the map!");
    }

    public void merge(SerializedMap map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || map.containsKey(key)) continue;
            map.put(key, value);
        }
    }

    public boolean containsKey(String key) {
        return this.map.contains(key);
    }

    public void putArray(Object ... associativeArray) {
        boolean string = true;
        String lastKey = null;
        for (Object obj : associativeArray) {
            if (string) {
                Valid.checkBoolean(obj instanceof String, "Expected String at " + obj + ", got " + obj.getClass().getSimpleName(), new Object[0]);
                lastKey = (String)obj;
            } else {
                this.map.override(lastKey, obj);
            }
            string = !string;
        }
    }

    public void putIfExist(String key, @Nullable Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    public void put(String key, Object value) {
        Valid.checkNotNull(value, "Value with key '" + key + "' is null!");
        this.map.put(key, value);
    }

    public void override(String key, Object value) {
        Valid.checkNotNull(value, "Value with key '" + key + "' is null!");
        this.map.override(key, value);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public void removeByValue(Object value) {
        this.map.removeByValue(value);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String def) {
        return this.get(key, String.class, def);
    }

    public Location getLocation(String key) {
        return this.get(key, Location.class, null);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long def) {
        Number n = this.get(key, Long.class, def);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer def) {
        return this.get(key, Integer.class, def);
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double def) {
        return this.get(key, Double.class, def);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float def) {
        return this.get(key, Float.class, def);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean def) {
        return this.get(key, Boolean.class, def);
    }

    public CompMaterial getMaterial(String key) {
        return this.getMaterial(key, null);
    }

    public CompMaterial getMaterial(String key, CompMaterial def) {
        String raw = this.getString(key);
        return raw != null ? CompMaterial.fromString(raw) : def;
    }

    public ItemStack getItem(String key) {
        return this.getItem(key, null);
    }

    public ItemStack getItem(String key, ItemStack def) {
        Object obj = this.get(key, Object.class, null);
        if (obj == null) {
            return def;
        }
        if (obj instanceof ItemStack) {
            return obj;
        }
        Map map = obj;
        ItemStack item = ItemStack.deserialize((Map)map);
        Object raw = map.get("meta");
        if (raw != null) {
            if (raw instanceof ItemMeta) {
                item.setItemMeta((ItemMeta)raw);
            } else if (raw instanceof Map) {
                Map meta = (Map)raw;
                try {
                    Class<?> cl = ReflectionUtil.getOBCClass("inventory." + (meta.containsKey("spawnedType") ? "CraftMetaSpawnEgg" : "CraftMetaItem"));
                    Constructor<?> c = cl.getDeclaredConstructor(Map.class);
                    c.setAccessible(true);
                    Object craftMeta = c.newInstance((Map)raw);
                    if (craftMeta instanceof ItemMeta) {
                        item.setItemMeta((ItemMeta)craftMeta);
                    }
                }
                catch (Throwable t) {
                    List itemFlags;
                    SerializedMap enchants;
                    List lore;
                    String display;
                    ItemMeta itemMeta = item.getItemMeta();
                    String string = display = meta.containsKey("display-name") ? (String)meta.get("display-name") : null;
                    if (display != null) {
                        itemMeta.setDisplayName(display);
                    }
                    List list = lore = meta.containsKey("lore") ? (List)meta.get("lore") : null;
                    if (lore != null) {
                        itemMeta.setLore(lore);
                    }
                    SerializedMap serializedMap = enchants = meta.containsKey("enchants") ? SerializedMap.of(meta.get("enchants")) : null;
                    if (enchants != null) {
                        for (Map.Entry<String, Object> entry : enchants.entrySet()) {
                            Enchantment enchantment = Enchantment.getByName((String)entry.getKey());
                            int level = (Integer)entry.getValue();
                            itemMeta.addEnchant(enchantment, level, true);
                        }
                    }
                    List list2 = itemFlags = meta.containsKey("ItemFlags") ? (List)meta.get("ItemFlags") : null;
                    if (itemFlags != null) {
                        for (String flag : itemFlags) {
                            try {
                                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
                            }
                            catch (Exception exception) {}
                        }
                    }
                    System.out.println("**************** NOTICE ****************");
                    System.out.println(SimplePlugin.getNamed() + " manually deserialized your item.");
                    System.out.println("Item: " + item);
                    System.out.println("This is ONLY supported for basic items, items having");
                    System.out.println("special flags like monster eggs will NOT function.");
                    item.setItemMeta(itemMeta);
                }
            }
        }
        return item;
    }

    public <K, V> Tuple<K, V> getTuple(String key) {
        return this.getTuple(key, null);
    }

    public <K, V> Tuple<K, V> getTuple(String key, Tuple<K, V> def) {
        return this.get(key, Tuple.class, def);
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, null);
    }

    public List<String> getStringList(String key, List<String> def) {
        List<String> list = this.getList(key, String.class);
        return list == null ? def : list;
    }

    public List<SerializedMap> getMapList(String key) {
        return this.getList(key, SerializedMap.class);
    }

    public <T> List<T> getListSafe(String key, Class<T> type) {
        List<T> list = this.getList(key, type);
        return Common.getOrDefault(list, new ArrayList());
    }

    public <T> Set<T> getSetSafe(String key, Class<T> type) {
        Set<T> list = this.getSet(key, type);
        return Common.getOrDefault(list, new HashSet());
    }

    public <T> Set<T> getSet(String key, Class<T> type) {
        List<T> list = this.getList(key, type);
        return list == null ? null : new HashSet<T>(list);
    }

    public <T> List<T> getList(String key, Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!this.map.contains(key)) {
            return list;
        }
        Object rawList = this.map.get(key);
        Valid.checkBoolean(rawList instanceof List, "Key '" + key + "' expected to have a list, got " + rawList.getClass().getSimpleName() + " instead!", new Object[0]);
        for (Object object : (List)rawList) {
            list.add(object == null ? null : (Object)SerializeUtil.deserialize(type, object));
        }
        return list;
    }

    public SerializedMap getMap(String key) {
        Object raw = this.get(key, Object.class);
        return raw != null ? SerializedMap.of(Common.getMapFromSection(raw)) : new SerializedMap();
    }

    public Object getObject(String key) {
        return this.get(key, Object.class);
    }

    public Object getObject(String key, Object def) {
        return this.get(key, Object.class, def);
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, type, null);
    }

    private <T> T get(String key, Class<T> type, T def) {
        Object raw = this.map.get(key);
        if (raw == null) {
            raw = this.getValueIgnoreCase(key);
        }
        if ("".equals(raw) && Enum.class.isAssignableFrom(type)) {
            return def;
        }
        return raw == null ? def : SerializeUtil.deserialize(type, raw, key);
    }

    public Object getValueIgnoreCase(String key) {
        for (Map.Entry<String, Object> e : this.map.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(key)) continue;
            return e.getValue();
        }
        return null;
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        for (Map.Entry<String, Object> e : this.map.entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Map<String, Object> asMap() {
        return this.map.getSource();
    }

    @Override
    public Object serialize() {
        return this.map.serialize();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public <O, N> void convert(String path, Class<O> from, Class<N> to, Function<O, N> converter) {
        Object old = this.getObject(path);
        if (old != null) {
            if (old instanceof Collection) {
                Collection collection = (Collection)old;
                if (collection.isEmpty() || !from.isAssignableFrom(collection.iterator().next().getClass())) {
                    return;
                }
                ArrayList<N> newCollection = new ArrayList<N>();
                for (Object oldItem : collection) {
                    newCollection.add(converter.apply(oldItem));
                }
                this.override(path, newCollection);
                Common.logNoPrefix("[" + SimplePlugin.getNamed() + "] Converted '" + path + "' from " + from.getSimpleName() + "[] to " + to.getSimpleName() + "[]");
            } else if (from.isAssignableFrom(old.getClass())) {
                this.override(path, converter.apply(old));
                Common.logNoPrefix("[" + SimplePlugin.getNamed() + "] Converted '" + path + "' from '" + from.getSimpleName() + "' to '" + to.getSimpleName() + "'");
            }
        }
    }

    public String toJson() {
        return gson.toJson(this.serialize());
    }

    public String toString() {
        return this.serialize().toString();
    }

    public static SerializedMap of(String key, Object value) {
        return new SerializedMap(key, value);
    }

    public static SerializedMap ofArray(Object ... array) {
        if (array != null && array.length == 1) {
            Object firstArgument = array[0];
            if (firstArgument instanceof SerializedMap) {
                return (SerializedMap)firstArgument;
            }
            if (firstArgument instanceof Map) {
                return SerializedMap.of((Map)firstArgument);
            }
            if (firstArgument instanceof StrictMap) {
                return SerializedMap.of(((StrictMap)firstArgument).getSource());
            }
        }
        SerializedMap map = new SerializedMap();
        map.putArray(array);
        return map;
    }

    public static SerializedMap of(Object object) {
        if (object instanceof SerializedMap) {
            return (SerializedMap)object;
        }
        if (object instanceof Map || object instanceof MemorySection) {
            return SerializedMap.of(Common.getMapFromSection(object));
        }
        return new SerializedMap();
    }

    public static SerializedMap of(Map<String, Object> map) {
        SerializedMap serialized = new SerializedMap();
        serialized.map.clear();
        serialized.map.putAll(map);
        return serialized;
    }

    public static SerializedMap fromJson(String json) {
        SerializedMap serializedMap = new SerializedMap();
        Map map = (Map)gson.fromJson(json, Map.class);
        serializedMap.map.putAll(map);
        return serializedMap;
    }
}

