/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.bungee.message;

import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.bungee.BungeeAction;
import org.mineacademy.fo.plugin.SimplePlugin;

abstract class Message {
    private String serverName;
    private BungeeAction action;
    private int actionHead = 0;

    protected final void setServerName(String serverName) {
        Valid.checkBoolean(this.serverName == null, "ServerName already set", new Object[0]);
        Valid.checkNotNull(serverName, "Server name cannot be null!");
        this.serverName = serverName;
    }

    protected final void setAction(String actionName) {
        BungeeAction action = BungeeAction.getByName(actionName);
        Valid.checkNotNull(action, "Unknown action named: " + actionName + ". Available: " + Common.join(SimplePlugin.getInstance().getBungeeCord().getActions()));
        this.setAction(action);
    }

    protected final void setAction(BungeeAction action) {
        Valid.checkBoolean(this.action == null, "Action already set", new Object[0]);
        this.action = action;
    }

    public <T extends BungeeAction> T getAction() {
        return (T)this.action;
    }

    protected final void moveHead(Class<?> typeOf) {
        Valid.checkNotNull(this.serverName, "Server name not set!");
        Valid.checkNotNull(this.action, "Action not set!");
        Class<?>[] content = this.action.getContent();
        Valid.checkBoolean(this.actionHead < content.length, "Head out of bounds! Max data size for " + this.action.name() + " is " + content.length, new Object[0]);
        ++this.actionHead;
    }

    public final String getChannel() {
        return SimplePlugin.getInstance().getBungeeCord().getChannel();
    }

    protected Message() {
    }

    public String getServerName() {
        return this.serverName;
    }
}

