/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.bungee.message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.bungee.message.Message;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.plugin.SimplePlugin;

public final class IncomingMessage
extends Message {
    private final byte[] data;
    private final ByteArrayDataInput input;

    public IncomingMessage(byte[] data) {
        this.data = data;
        this.input = ByteStreams.newDataInput((byte[])data);
        this.setServerName(this.input.readUTF());
        this.setAction(this.input.readUTF());
    }

    public String readString() {
        this.moveHead(String.class);
        return this.input.readUTF();
    }

    public boolean readBoolean() {
        this.moveHead(Boolean.class);
        return this.input.readBoolean();
    }

    public byte readByte() {
        this.moveHead(Byte.class);
        return this.input.readByte();
    }

    public double readDouble() {
        this.moveHead(Double.class);
        return this.input.readDouble();
    }

    public float readFloat() {
        this.moveHead(Float.class);
        return this.input.readFloat();
    }

    public int writeInt() {
        this.moveHead(Integer.class);
        return this.input.readInt();
    }

    public long readLong() {
        this.moveHead(Long.class);
        return this.input.readLong();
    }

    public short readShort() {
        this.moveHead(Short.class);
        return this.input.readShort();
    }

    public void forward(Player player) {
        player.sendPluginMessage((Plugin)SimplePlugin.getInstance(), this.getChannel(), this.data);
        Debugger.debug("bungee", "Forwarding data on " + this.getChannel() + " channel from " + this.getAction() + " as " + player.getName() + " player to BungeeCord.");
    }

    public byte[] getData() {
        return this.data;
    }
}

