/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.bungee;

import java.lang.reflect.Constructor;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.bungee.BungeeAction;
import org.mineacademy.fo.bungee.BungeeListener;

public final class SimpleBungee {
    private final String channel;
    private final BungeeListener listener;
    private final BungeeAction[] actions;

    public SimpleBungee(String channel, Class<? extends BungeeListener> listenerClass, Class<? extends BungeeAction> actionEnum) {
        this(channel, SimpleBungee.toListener(listenerClass), SimpleBungee.toAction(actionEnum));
    }

    private static BungeeListener toListener(Class<? extends BungeeListener> listenerClass) {
        Valid.checkNotNull(listenerClass);
        try {
            Constructor<? extends BungeeListener> con = listenerClass.getConstructor(new Class[0]);
            con.setAccessible(true);
            return con.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            System.out.println("Unable to create new instance of " + listenerClass + ", ensure constructor is public without parameters!");
            ex.printStackTrace();
            return null;
        }
    }

    private static BungeeAction[] toAction(Class<? extends BungeeAction> actionEnum) {
        Valid.checkNotNull(actionEnum);
        Valid.checkBoolean(actionEnum.isEnum(), "Enum expected, given: " + actionEnum, new Object[0]);
        try {
            return (BungeeAction[])actionEnum.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            System.out.println("Unable to get values() of " + actionEnum + ", ensure it is an enum!");
            ex.printStackTrace();
            return null;
        }
    }

    public SimpleBungee(String channel, BungeeListener listener, BungeeAction ... actions) {
        Valid.checkNotNull(channel, "Channel cannot be null!");
        this.channel = channel;
        this.listener = listener;
        Valid.checkNotNull(actions, "Actions cannot be null!");
        this.actions = actions;
    }

    public String getChannel() {
        return this.channel;
    }

    public BungeeListener getListener() {
        return this.listener;
    }

    public BungeeAction[] getActions() {
        return this.actions;
    }
}

