/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.Vector;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.PlayerUtil;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.model.RangedValue;
import org.mineacademy.fo.settings.SimpleLocalization;

public final class Valid {
    private static final Pattern PATTERN_INTEGER = Pattern.compile("-?\\d+");
    private static final Pattern PATTERN_DECIMAL = Pattern.compile("-?\\d+.\\d+");

    public static void checkNotNull(Object toCheck) {
        if (toCheck == null) {
            throw new FoException();
        }
    }

    public static void checkNotNull(Object toCheck, String falseMessage) {
        if (toCheck == null) {
            throw new FoException(falseMessage);
        }
    }

    public static void checkBoolean(boolean expression) {
        if (!expression) {
            throw new FoException();
        }
    }

    public static void checkBoolean(boolean expression, String falseMessage, Object ... replacements) {
        if (!expression) {
            throw new FoException(String.format(falseMessage, replacements));
        }
    }

    public static void checkInteger(String toCheck, String falseMessage, Object ... replacements) {
        if (!Valid.isInteger(toCheck)) {
            throw new FoException(String.format(falseMessage, replacements));
        }
    }

    public static void checkNotEmpty(Collection<?> collection, String message) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean checkPermission(CommandSender sender, String permission) {
        if (!PlayerUtil.hasPerm((Permissible)sender, permission)) {
            Common.tell(sender, SimpleLocalization.NO_PERMISSION.replace("{permission}", permission));
            return false;
        }
        return true;
    }

    public static void checkSync(String asyncErrorMessage) {
        Valid.checkBoolean(Bukkit.isPrimaryThread(), asyncErrorMessage, new Object[0]);
    }

    public static void checkAsync(String syncErrorMessage) {
        Valid.checkBoolean(!Bukkit.isPrimaryThread(), syncErrorMessage, new Object[0]);
    }

    public static boolean isInteger(String raw) {
        return PATTERN_INTEGER.matcher(raw).find();
    }

    public static boolean isDecimal(String raw) {
        return PATTERN_DECIMAL.matcher(raw).find();
    }

    public static boolean isNullOrEmpty(Collection<?> array) {
        return array == null || Valid.isNullOrEmpty(array.toArray());
    }

    public static boolean isNullOrEmpty(Object[] array) {
        if (array != null) {
            for (Object object : array) {
                if (!(object instanceof String ? !((String)object).isEmpty() : object != null)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNullOrEmpty(String message) {
        return message == null || message.isEmpty();
    }

    public static boolean isFinite(Vector vector) {
        return Double.isFinite(vector.getX()) && Double.isFinite(vector.getY()) && Double.isFinite(vector.getZ());
    }

    public static boolean isInRange(long value, RangedValue ranged) {
        return value >= ranged.getMinLong() && value <= ranged.getMaxLong();
    }

    public static boolean isInRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean locationEquals(Location first, Location sec) {
        if (!first.getWorld().getName().equals(sec.getWorld().getName())) {
            return false;
        }
        return first.getBlockX() == sec.getBlockX() && first.getBlockY() == sec.getBlockY() && first.getBlockZ() == sec.getBlockZ();
    }

    public static <T> boolean listEquals(List<T> first, List<T> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            T f = first.get(i);
            T s = second.get(i);
            if (f == null && s != null) {
                return false;
            }
            if (f != null && s == null) {
                return false;
            }
            if (f == null || f.equals(s) || Common.stripColors(f.toString()).equalsIgnoreCase(Common.stripColors(s.toString()))) continue;
            return false;
        }
        return true;
    }

    public static boolean colorlessEquals(String first, String second) {
        return Common.stripColors(first).equals(Common.stripColors(second));
    }

    public static boolean colorlessEquals(List<String> first, List<String> second) {
        return Valid.colorlessEquals(Common.toArray(first), Common.toArray(second));
    }

    public static boolean colorlessEquals(String[] firstArray, String[] secondArray) {
        for (int i = 0; i < firstArray.length; ++i) {
            String second;
            String first = Common.stripColors(firstArray[i]);
            String string = second = i < secondArray.length ? Common.stripColors(secondArray[i]) : "";
            if (first.equals(second)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInList(String element, boolean isBlacklist, Iterable<String> list) {
        return isBlacklist == Valid.isInList(element, list);
    }

    public static boolean isInList(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.normalizeEquals(element).equals(Valid.normalizeEquals(matched))) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListStartsWith(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.normalizeEquals(element).startsWith(Valid.normalizeEquals(matched))) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListContains(String element, Iterable<String> list) {
        try {
            for (String matched : list) {
                if (!Valid.normalizeEquals(element).contains(Valid.normalizeEquals(matched))) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isInListRegex(String element, Iterable<String> list) {
        try {
            for (String regex : list) {
                if (!Common.regExMatch(regex, element)) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private static String normalizeEquals(String message) {
        if (message.startsWith("/")) {
            message = message.substring(1);
        }
        return message.toLowerCase();
    }

    private Valid() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

