/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.RegexTimeoutException;

final class TimedCharSequence
implements CharSequence {
    private final CharSequence message;
    private final int timeoutLimit;

    public TimedCharSequence(CharSequence message, Integer timeoutLimit) {
        Valid.checkNotNull(message, "msg = null");
        Valid.checkNotNull(timeoutLimit, "timeout = null");
        this.message = message;
        this.timeoutLimit = timeoutLimit;
    }

    @Override
    public char charAt(int index) {
        if (System.currentTimeMillis() > System.currentTimeMillis() + (long)this.timeoutLimit) {
            throw new RegexTimeoutException(this.message, this.timeoutLimit);
        }
        return this.message.charAt(index);
    }

    @Override
    public int length() {
        return this.message.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new TimedCharSequence(this.message.subSequence(start, end), this.timeoutLimit);
    }

    @Override
    public String toString() {
        return this.message.toString();
    }
}

