/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;

public final class TimeUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("dd.MM.yyyy HH:mm");

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long currentTimeTicks() {
        return System.currentTimeMillis() / 50L;
    }

    public static String getFormattedDate() {
        return TimeUtil.getFormattedDate(System.currentTimeMillis());
    }

    public static String getFormattedDate(long time) {
        return DATE_FORMAT.format(time);
    }

    public static String getFormattedDateShort() {
        return DATE_FORMAT_SHORT.format(System.currentTimeMillis());
    }

    public static String getFormattedDateShort(long time) {
        return DATE_FORMAT_SHORT.format(time);
    }

    public static long toTicks(String humanReadableTime) {
        Valid.checkNotNull(humanReadableTime, "Time is null");
        long seconds = 0L;
        String[] split = humanReadableTime.split(" ");
        for (int i = 1; i < split.length; ++i) {
            String sub = split[i].toLowerCase();
            int multiplier = 0;
            long unit = 0L;
            boolean isTicks = false;
            try {
                multiplier = Integer.parseInt(split[i - 1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (sub.startsWith("tick")) {
                isTicks = true;
            } else if (sub.startsWith("second")) {
                unit = 1L;
            } else if (sub.startsWith("minute")) {
                unit = 60L;
            } else if (sub.startsWith("hour")) {
                unit = 3600L;
            } else if (sub.startsWith("day")) {
                unit = 86400L;
            } else if (sub.startsWith("week")) {
                unit = 604800L;
            } else if (sub.startsWith("month")) {
                unit = 2629743L;
            } else if (sub.startsWith("year")) {
                unit = 31556926L;
            } else {
                throw new FoException("Must define date type! Example: '1 second' (Got '" + sub + "')");
            }
            seconds += (long)multiplier * (isTicks ? 1L : unit * 20L);
        }
        return seconds;
    }

    public static String formatTimeGeneric(long seconds) {
        long second = seconds % 60L;
        long minute = seconds / 60L;
        String hourMsg = "";
        if (minute >= 60L) {
            long hour = seconds / 60L / 60L;
            minute %= 60L;
            hourMsg = hour + (hour == 1L ? " hour" : " hours") + " ";
        }
        return hourMsg + (minute != 0L ? Long.valueOf(minute) : "") + (minute > 0L ? (minute == 1L ? " minute" : " minutes") + " " : "") + Long.parseLong(String.valueOf(second)) + (Long.parseLong(String.valueOf(second)) == 1L ? " second" : " seconds");
    }

    public static String formatTimeDays(long seconds) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return days + " days " + hours % 24L + " hours " + minutes % 60L + " minutes " + seconds % 60L + " seconds";
    }

    public static String formatTimeShort(long seconds) {
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        return (days > 0L ? days + "d " : "") + (hours > 0L ? (hours %= 24L) + "h " : "") + (minutes > 0L ? (minutes %= 60L) + "m " : "") + (seconds %= 60L) + "s";
    }

    private TimeUtil() {
    }
}

