/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MathUtil;

public final class TabUtil {
    public static List<String> completePlayerName(String partialName) {
        return TabUtil.complete(partialName, Common.getPlayerNames());
    }

    @SafeVarargs
    public static <T> List<String> complete(String partialName, T ... all) {
        ArrayList<String> clone = new ArrayList<String>();
        for (T s : all) {
            if (s == null) continue;
            if (s instanceof ChatColor) {
                clone.add(((ChatColor)s).name().toLowerCase());
                continue;
            }
            if (s instanceof CommandSender) {
                clone.add(((CommandSender)s).getName());
                continue;
            }
            if (s instanceof EntityType) {
                if (!((EntityType)s).isAlive() || !((EntityType)s).isSpawnable()) continue;
                clone.add(s.toString().toLowerCase());
                continue;
            }
            if (s instanceof Enum) {
                clone.add(s.toString().toLowerCase());
                continue;
            }
            if (s instanceof Double) {
                clone.add(MathUtil.formatTwoDigits(Double.parseDouble(s.toString())));
                continue;
            }
            if (s instanceof Float) {
                clone.add(MathUtil.formatTwoDigits(Float.parseFloat(s.toString())));
                continue;
            }
            clone.add(s.toString());
        }
        return TabUtil.complete(partialName, clone);
    }

    public static List<String> complete(String partialName, Iterable<String> all) {
        ArrayList<String> tab = new ArrayList<String>();
        for (String s : all) {
            tab.add(s);
        }
        partialName = partialName.toLowerCase();
        Iterator iterator = tab.iterator();
        while (iterator.hasNext()) {
            String val = (String)iterator.next();
            if (val.toLowerCase().startsWith(partialName)) continue;
            iterator.remove();
        }
        return tab;
    }

    private TabUtil() {
    }
}

