/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictCollection;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.collection.StrictSet;
import org.mineacademy.fo.exception.InvalidWorldException;
import org.mineacademy.fo.menu.model.ItemCreator;
import org.mineacademy.fo.model.ConfigSerializable;
import org.mineacademy.fo.model.IsInList;
import org.mineacademy.fo.model.SimpleTime;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.settings.YamlConfig;

public final class SerializeUtil {
    public static Object serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ConfigSerializable) {
            return SerializeUtil.serialize(((ConfigSerializable)obj).serialize().serialize());
        }
        if (obj instanceof StrictCollection) {
            return SerializeUtil.serialize(((StrictCollection)obj).serialize());
        }
        if (obj instanceof ChatColor) {
            return ((ChatColor)obj).name();
        }
        if (obj instanceof CompMaterial) {
            return obj.toString();
        }
        if (obj instanceof Location) {
            return SerializeUtil.serializeLoc((Location)obj);
        }
        if (obj instanceof UUID) {
            return obj.toString();
        }
        if (obj instanceof Enum) {
            return obj.toString();
        }
        if (obj instanceof CommandSender) {
            return ((CommandSender)obj).getName();
        }
        if (obj instanceof World) {
            return ((World)obj).getName();
        }
        if (obj instanceof PotionEffect) {
            return SerializeUtil.serializePotionEffect((PotionEffect)obj);
        }
        if (obj instanceof ItemCreator.ItemCreatorBuilder) {
            return ((ItemCreator.ItemCreatorBuilder)obj).build().make();
        }
        if (obj instanceof ItemCreator) {
            return ((ItemCreator)obj).make();
        }
        if (obj instanceof SimpleTime) {
            return ((SimpleTime)obj).getRaw();
        }
        if (obj instanceof Iterable || obj.getClass().isArray() || obj instanceof IsInList) {
            ArrayList<Object> serialized = new ArrayList<Object>();
            if (obj instanceof Iterable || obj instanceof IsInList) {
                for (Object element : obj instanceof IsInList ? ((IsInList)obj).getList() : (StrictSet)obj) {
                    serialized.add(SerializeUtil.serialize(element));
                }
            } else {
                for (Object element : (Object[])obj) {
                    serialized.add(SerializeUtil.serialize(element));
                }
            }
            return serialized;
        }
        if (obj instanceof StrictMap) {
            StrictMap oldMap = (StrictMap)obj;
            StrictMap<Object, Object> newMap = new StrictMap<Object, Object>();
            for (Map.Entry entry : oldMap.entrySet()) {
                newMap.put(SerializeUtil.serialize(entry.getKey()), SerializeUtil.serialize(entry.getValue()));
            }
            return newMap;
        }
        if (obj instanceof Map) {
            Map oldMap = (Map)obj;
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry entry : oldMap.entrySet()) {
                newMap.put(SerializeUtil.serialize(entry.getKey()), SerializeUtil.serialize(entry.getValue()));
            }
            return newMap;
        }
        if (obj instanceof YamlConfig) {
            throw new SerializeFailedException("To save your YamlConfig " + obj.getClass().getSimpleName() + " make it implement ConfigSerializable!");
        }
        if (obj instanceof Integer || obj instanceof Double || obj instanceof Float || obj instanceof Long || obj instanceof Short || obj instanceof String || obj instanceof Boolean || obj instanceof Map || obj instanceof ItemStack || obj instanceof MemorySection) {
            return obj;
        }
        if (obj instanceof ConfigurationSerializable) {
            return ((ConfigurationSerializable)obj).serialize();
        }
        throw new SerializeFailedException("Does not know how to serialize " + obj.getClass().getSimpleName() + "! Does it extends ConfigSerializable? Data: " + obj);
    }

    public static String serializeLoc(Location loc) {
        return loc.getWorld().getName() + " " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + (loc.getPitch() != 0.0f || loc.getYaw() != 0.0f ? " " + Math.round(loc.getYaw()) + " " + Math.round(loc.getPitch()) : "");
    }

    private static String serializePotionEffect(PotionEffect effect) {
        return effect.getType().getName() + " " + effect.getDuration() + " " + effect.getAmplifier();
    }

    public static <T> T deserialize(@NonNull Class<T> classOf, @NonNull Object object) {
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return SerializeUtil.deserialize(classOf, object, null);
    }

    public static <T> T deserialize(@NonNull Class<T> classOf, @NonNull Object object, Object ... deserializeParameters) {
        if (classOf == null) {
            throw new NullPointerException("classOf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        SerializedMap map = SerializedMap.of(object);
        Method deserializeMethod = ReflectionUtil.getMethod(classOf, "deserialize", SerializedMap.class);
        if (deserializeMethod != null) {
            return ReflectionUtil.invokeStatic(deserializeMethod, map);
        }
        if (deserializeParameters != null) {
            ArrayList joinedClasses = new ArrayList();
            joinedClasses.add(SerializedMap.class);
            for (Object param : deserializeParameters) {
                joinedClasses.add(param.getClass());
            }
            deserializeMethod = ReflectionUtil.getMethod(classOf, "deserialize", joinedClasses.toArray(new Class[joinedClasses.size()]));
            ArrayList<Object> joinedParams = new ArrayList<Object>();
            joinedParams.add(map);
            for (Object param : deserializeParameters) {
                joinedParams.add(param);
            }
            if (deserializeMethod != null) {
                Valid.checkBoolean(joinedClasses.size() == joinedParams.size(), "static deserialize method arguments length " + joinedClasses.size() + " != given params " + joinedParams.size(), new Object[0]);
                return ReflectionUtil.invokeStatic(deserializeMethod, joinedParams.toArray());
            }
        }
        if (deserializeMethod == null && object instanceof String && (deserializeMethod = ReflectionUtil.getMethod(classOf, "getByName", String.class)) != null) {
            return ReflectionUtil.invokeStatic(deserializeMethod, object);
        }
        if (object != null) {
            if (classOf == String.class) {
                object = object.toString();
            } else if (classOf == Integer.class) {
                object = Double.valueOf(object.toString()).intValue();
            } else if (classOf == Long.class) {
                object = Double.valueOf(object.toString()).longValue();
            } else if (classOf == Double.class) {
                object = Double.valueOf(object.toString());
            } else if (classOf == Float.class) {
                object = Float.valueOf(object.toString());
            } else if (classOf == Boolean.class) {
                object = Boolean.valueOf(object.toString());
            } else if (classOf == SerializedMap.class) {
                object = SerializedMap.of(object);
            } else if (classOf == Location.class) {
                object = SerializeUtil.deserializeLocation(object);
            } else if (classOf == PotionEffect.class) {
                object = SerializeUtil.deserializePotionEffect(object);
            } else if (classOf == CompMaterial.class) {
                object = CompMaterial.fromString(object.toString());
            } else if (classOf == SimpleTime.class) {
                object = SimpleTime.from(object.toString());
            } else if (classOf == UUID.class) {
                object = UUID.fromString(object.toString());
            } else if (Enum.class.isAssignableFrom(classOf)) {
                object = ReflectionUtil.lookupEnum(classOf, object.toString());
            } else if (!(List.class.isAssignableFrom(classOf) && object instanceof List || Map.class.isAssignableFrom(classOf) && object instanceof Map || ConfigurationSerializable.class.isAssignableFrom(classOf) && object instanceof ConfigurationSerializable || classOf == Object.class)) {
                throw new SerializeFailedException("Unable to deserialize " + classOf.getSimpleName() + ", lacking static deserialize method! Data: " + object);
            }
        }
        return (T)object;
    }

    public static Location deserializeLocation(Object raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof Location) {
            return (Location)raw;
        }
        String[] parts = raw.toString().contains(", ") ? raw.toString().split(", ") : raw.toString().split(" ");
        Valid.checkBoolean(parts.length == 4 || parts.length == 6, "Expected location (String) but got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        String world = parts[0];
        World bukkitWorld = Bukkit.getWorld((String)world);
        if (bukkitWorld == null) {
            throw new InvalidWorldException("Location with invalid world '" + world + "': " + raw + " (Doesn't exist)");
        }
        int x = Integer.parseInt(parts[1]);
        int y = Integer.parseInt(parts[2]);
        int z = Integer.parseInt(parts[3]);
        float yaw = Float.parseFloat(parts.length == 6 ? parts[4] : "0");
        float pitch = Float.parseFloat(parts.length == 6 ? parts[5] : "0");
        return new Location(bukkitWorld, (double)x, (double)y, (double)z, yaw, pitch);
    }

    private static PotionEffect deserializePotionEffect(Object raw) {
        if (raw == null) {
            return null;
        }
        if (raw instanceof PotionEffect) {
            return (PotionEffect)raw;
        }
        String[] parts = raw.toString().split(" ");
        Valid.checkBoolean(parts.length == 3, "Expected PotionEffect (String) but got " + raw.getClass().getSimpleName() + ": " + raw, new Object[0]);
        String typeRaw = parts[0];
        PotionEffectType type = PotionEffectType.getByName((String)typeRaw);
        int duration = Integer.parseInt(parts[1]);
        int amplifier = Integer.parseInt(parts[2]);
        return new PotionEffect(type, duration, amplifier);
    }

    @Deprecated
    public static <T extends ConfigSerializable> List<T> deserializeMapList(Object listOfObjects, Class<T> asWhat) {
        if (listOfObjects == null) {
            return null;
        }
        Valid.checkBoolean(listOfObjects instanceof ArrayList, "Only deserialize a list of maps, nie " + listOfObjects.getClass(), new Object[0]);
        ArrayList<T> loaded = new ArrayList<T>();
        for (Object part : (ArrayList)listOfObjects) {
            T deserialized = SerializeUtil.deserializeMap(part, asWhat);
            if (deserialized == null) continue;
            loaded.add(deserialized);
        }
        return loaded;
    }

    public static <T extends ConfigSerializable> T deserializeMap(Object rawMap, Class<T> asWhat) {
        Object invoked;
        Method deserialize;
        if (rawMap == null) {
            return null;
        }
        Valid.checkBoolean(rawMap instanceof Map, "The object to deserialize must be map, but got: " + rawMap.getClass(), new Object[0]);
        Map map = (Map)rawMap;
        try {
            deserialize = asWhat.getMethod("deserialize", SerializedMap.class);
            Valid.checkBoolean(Modifier.isPublic(deserialize.getModifiers()) && Modifier.isStatic(deserialize.getModifiers()), asWhat + " is missing public 'public static T deserialize()' method", new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            Common.throwError(ex, "Class lacks a final method deserialize(SerializedMap) metoda. Tried: " + asWhat.getSimpleName());
            return null;
        }
        try {
            invoked = deserialize.invoke(null, SerializedMap.of(map));
        }
        catch (ReflectiveOperationException e) {
            Common.throwError(e, "Error calling " + deserialize.getName() + " as " + asWhat.getSimpleName() + " with data " + map);
            return null;
        }
        Valid.checkBoolean(invoked.getClass().isAssignableFrom(asWhat), invoked.getClass().getSimpleName() + " != " + asWhat.getSimpleName(), new Object[0]);
        return (T)((ConfigSerializable)invoked);
    }

    private SerializeUtil() {
    }

    public static class SerializeFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SerializeFailedException(String reason) {
            super(reason);
        }
    }
}

