/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.NonNull;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;

public final class ReflectionUtil {
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<Class<?>, ReflectionData<?>> reflectionDataCache = new ConcurrentHashMap();
    private static final Collection<String> classNameGuard = ConcurrentHashMap.newKeySet();
    public static final String NMS = "net.minecraft.server";
    public static final String CRAFTBUKKIT = "org.bukkit.craftbukkit";

    public static Class<?> getNMSClass(String name) {
        return ReflectionUtil.lookupClass("net.minecraft.server." + MinecraftVersion.getServerVersion() + "." + name);
    }

    public static Class<?> getOBCClass(String name) {
        return ReflectionUtil.lookupClass("org.bukkit.craftbukkit." + MinecraftVersion.getServerVersion() + "." + name);
    }

    public static Constructor<?> getConstructor(@NonNull String classPath, Class<?> ... params) {
        if (classPath == null) {
            throw new NullPointerException("classPath is marked non-null but is null");
        }
        Class clazz = ReflectionUtil.lookupClass(classPath);
        return ReflectionUtil.getConstructor(clazz, params);
    }

    public static Constructor<?> getConstructor(@NonNull Class<?> clazz, Class<?> ... params) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            if (reflectionDataCache.containsKey(clazz)) {
                return reflectionDataCache.get(clazz).getConstructor(params);
            }
            Constructor<?> constructor = clazz.getConstructor(params);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Could not get constructor of " + clazz + " with parameters " + Common.join(params));
        }
    }

    public static <T> T getFieldContent(Object instance, String field) {
        return ReflectionUtil.getFieldContent(instance.getClass(), field, instance);
    }

    public static <T> T getFieldContent(Class<?> clazz, String field, Object instance) {
        String originalClassName = clazz.getSimpleName();
        do {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                return (T)ReflectionUtil.getFieldContent(f, instance);
            }
        } while (!(clazz = clazz.getSuperclass()).isAssignableFrom(Object.class));
        throw new ReflectionException("No such field " + field + " in " + originalClassName + " or its superclasses");
    }

    public static Object getFieldContent(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Could not get field " + field.getName() + " in instance " + (instance != null ? instance : field).getClass().getSimpleName());
        }
    }

    public static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            list.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while (!(clazz = clazz.getSuperclass()).isAssignableFrom(Object.class));
        return list.toArray(new Field[0]);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            if (reflectionDataCache.containsKey(clazz)) {
                return reflectionDataCache.get(clazz).getDeclaredField(fieldName);
            }
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setDeclaredField(@NonNull Object instance, String fieldName, Object fieldValue) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        Field field = ReflectionUtil.getDeclaredField(instance.getClass(), fieldName);
        try {
            field.set(instance, fieldValue);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static <T> T getStaticFieldContent(@NonNull Class<?> clazz, String field) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return ReflectionUtil.getFieldContent(clazz, field, null);
    }

    public static void setStaticField(@NonNull Class<?> clazz, String fieldName, Object fieldValue) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            Field field = ReflectionUtil.getDeclaredField(clazz, fieldName);
            field.set(null, fieldValue);
        }
        catch (Throwable t) {
            throw new FoException(t, "Could not set " + fieldName + " in " + clazz + " to " + fieldValue);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !ReflectionUtil.isClassListEqual(args, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private static boolean isClassListEqual(Class<?>[] first, Class<?>[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        try {
            if (reflectionDataCache.containsKey(clazz)) {
                return reflectionDataCache.get(clazz).getDeclaredMethod(methodName, args);
            }
            return reflectionDataCache.computeIfAbsent(clazz, ReflectionData::new).getDeclaredMethod(methodName, args);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeStatic(Class<?> cl, String methodName, Object ... params) {
        return ReflectionUtil.invokeStatic(ReflectionUtil.getMethod(cl, methodName), params);
    }

    public static <T> T invokeStatic(Method method, Object ... params) {
        try {
            return (T)method.invoke(null, params);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Could not invoke static method " + method + " with params " + StringUtils.join((Object[])params), ex);
        }
    }

    public static <T> T invoke(String methodName, Object instance, Object ... params) {
        return ReflectionUtil.invoke(ReflectionUtil.getMethod(instance.getClass(), methodName), instance, params);
    }

    public static <T> T invoke(Method method, Object instance, Object ... params) {
        try {
            Valid.checkNotNull(method, "Method cannot be null for " + instance);
            return (T)method.invoke(instance, params);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Could not invoke method " + method + " on instance " + instance + " with params " + StringUtils.join((Object[])params), ex);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            Constructor<Object> constructor = reflectionDataCache.containsKey(clazz) ? reflectionDataCache.get(clazz).getDeclaredConstructor(new Class[0]) : clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Could not make instance of: " + clazz, e);
        }
    }

    public static <T> T instantiate(Class<T> clazz, Object ... params) {
        try {
            Constructor<Object> constructor;
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Object param : params) {
                Valid.checkNotNull(param, "Argument cannot be null when instatiating " + clazz);
                Class paramClass = param.getClass();
                classes.add(paramClass.isPrimitive() ? ClassUtils.wrapperToPrimitive(paramClass) : paramClass);
            }
            Class[] paramArr = classes.toArray(new Class[0]);
            if (reflectionDataCache.containsKey(clazz)) {
                constructor = reflectionDataCache.get(clazz).getDeclaredConstructor(paramArr);
            } else {
                classCache.put(clazz.getCanonicalName(), clazz);
                constructor = reflectionDataCache.computeIfAbsent(clazz, ReflectionData::new).getDeclaredConstructor(paramArr);
            }
            constructor.setAccessible(true);
            return (T)constructor.newInstance(params);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Could not make instance of: " + clazz, e);
        }
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... params) {
        try {
            return constructor.newInstance(params);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Could not make new instance of " + constructor + " with params: " + Common.join(params));
        }
    }

    public static boolean isClassAvailable(String path) {
        try {
            if (classCache.containsKey(path)) {
                return true;
            }
            Class.forName(path);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static <T> Class<T> lookupClass(String path) {
        if (classCache.containsKey(path)) {
            return classCache.get(path);
        }
        if (classNameGuard.contains(path)) {
            while (classNameGuard.contains(path)) {
            }
            return ReflectionUtil.lookupClass(path);
        }
        try {
            classNameGuard.add(path);
            Class<?> clazz = Class.forName(path);
            classCache.put(path, clazz);
            reflectionDataCache.computeIfAbsent(clazz, ReflectionData::new);
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException("Could not find class: " + path);
        }
        finally {
            classNameGuard.remove(path);
        }
    }

    public static <E extends Enum<E>> E lookupEnum(Class<E> enumType, String name) {
        return ReflectionUtil.lookupEnum(enumType, name, "The enum '" + enumType.getSimpleName() + "' does not contain '" + name + "' on MC " + MinecraftVersion.getServerVersion() + "! Available values: {available}");
    }

    public static <E extends Enum<E>> E lookupEnum(Class<E> enumType, String name, String errMessage) {
        Valid.checkNotNull(enumType, "Type missing for " + name);
        Valid.checkNotNull(name, "Name missing for " + enumType);
        String rawName = name.toUpperCase().replace(" ", "_");
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            if (enumType == Material.class) {
                if (rawName.equals("RAW_FISH")) {
                    name = "PUFFERFISH";
                } else if (rawName.equals("MONSTER_EGG")) {
                    name = "SHEEP_SPAWN_EGG";
                }
            }
            if (enumType == Biome.class && rawName.equalsIgnoreCase("ICE_MOUNTAINS")) {
                name = "SNOWY_TAIGA";
            }
        }
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14) && enumType == EntityType.class && rawName.equals("TIPPED_ARROW")) {
            name = "ARROW";
        }
        String oldName = name;
        E result = ReflectionUtil.lookupEnumSilent(enumType, name);
        if (result == null) {
            name = name.toUpperCase();
            result = ReflectionUtil.lookupEnumSilent(enumType, name);
        }
        if (result == null) {
            name = name.replace(" ", "_");
            result = ReflectionUtil.lookupEnumSilent(enumType, name);
        }
        if (result == null) {
            result = ReflectionUtil.lookupEnumSilent(enumType, name.replace("_", ""));
        }
        if (result == null) {
            name = name.endsWith("S") ? name.substring(0, name.length() - 1) : name + "S";
            result = ReflectionUtil.lookupEnumSilent(enumType, name);
        }
        if (result == null) {
            throw new MissingEnumException(oldName, errMessage.replace("{available}", StringUtils.join((Object[])enumType.getEnumConstants(), (String)", ")));
        }
        return result;
    }

    public static <E extends Enum<E>> E lookupEnumSilent(Class<E> enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static String getCallerMethods(int skipMethods, int count) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder methods = new StringBuilder();
        int counted = 0;
        for (int i = 2 + skipMethods; i < elements.length && counted < count; ++i) {
            String[] clazz;
            StackTraceElement el = elements[i];
            if (el.getMethodName().equals("getCallerMethods") || el.getClassName().indexOf("java.lang.Thread") == 0) continue;
            methods.append(clazz[(clazz = el.getClassName().split("\\.")).length == 0 ? 0 : clazz.length - 1]).append("#").append(el.getLineNumber()).append("-").append(el.getMethodName()).append("()").append(i + 1 == elements.length ? "" : ".");
            ++counted;
        }
        return methods.toString();
    }

    public static <T> List<Class<? extends T>> getClasses(Plugin plugin, @NonNull Class<T> extendingClass) {
        if (extendingClass == null) {
            throw new NullPointerException("extendingClass is marked non-null but is null");
        }
        ArrayList<Class<T>> found = new ArrayList<Class<T>>();
        for (Class<?> clazz : ReflectionUtil.getClasses(plugin)) {
            if (!extendingClass.isAssignableFrom(clazz) || clazz == extendingClass) continue;
            found.add(clazz);
        }
        return found;
    }

    public static TreeSet<Class<?>> getClasses(Plugin plugin) {
        Valid.checkNotNull(plugin, "Plugin is null!");
        Valid.checkBoolean(JavaPlugin.class.isAssignableFrom(plugin.getClass()), "Plugin must be a JavaPlugin", new Object[0]);
        Method m = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
        m.setAccessible(true);
        File pluginFile = (File)m.invoke((Object)plugin, new Object[0]);
        TreeSet classes = new TreeSet(Comparator.comparing(Class::toString));
        try (JarFile jarFile = new JarFile(pluginFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Class<?> clazz;
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") || (name = name.replace("/", ".").replaceFirst(".class", "")).startsWith("de.exceptionflug.protocolize.api")) continue;
                try {
                    clazz = Class.forName(name);
                }
                catch (Throwable throwable) {
                    continue;
                }
                classes.add(clazz);
            }
        }
        return classes;
    }

    private ReflectionUtil() {
    }

    public static final class MissingEnumException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String enumName;

        public MissingEnumException(String enumName, String msg) {
            super(msg);
            this.enumName = enumName;
        }

        public MissingEnumException(String enumName, String msg, Exception ex) {
            super(msg, ex);
            this.enumName = enumName;
        }

        public String getEnumName() {
            return this.enumName;
        }
    }

    public static final class ReflectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionException(String msg) {
            super(msg);
        }

        public ReflectionException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    private static final class ReflectionData<T> {
        private final Class<T> clazz;
        private final Map<String, Collection<Method>> methodCache = new ConcurrentHashMap<String, Collection<Method>>();
        private final Map<Integer, Constructor<?>> constructorCache = new ConcurrentHashMap();
        private final Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();
        private final Collection<String> fieldGuard = ConcurrentHashMap.newKeySet();
        private final Collection<Integer> constructorGuard = ConcurrentHashMap.newKeySet();

        ReflectionData(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void cacheConstructor(Constructor<T> constructor) {
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Class clazz : constructor.getParameterTypes()) {
                Valid.checkNotNull(clazz, "Argument cannot be null when instatiating " + this.clazz);
                classes.add(clazz.isPrimitive() ? ClassUtils.wrapperToPrimitive(clazz) : clazz);
            }
            this.constructorCache.put(Arrays.hashCode(classes.toArray(new Class[0])), constructor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Constructor<T> getDeclaredConstructor(Class<?> ... paramTypes) throws NoSuchMethodException {
            Integer hashCode = Arrays.hashCode(paramTypes);
            if (this.constructorCache.containsKey(hashCode)) {
                return this.constructorCache.get(hashCode);
            }
            if (this.constructorGuard.contains(hashCode)) {
                while (this.constructorGuard.contains(hashCode)) {
                }
                return this.getDeclaredConstructor(paramTypes);
            }
            this.constructorGuard.add(hashCode);
            try {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(paramTypes);
                this.cacheConstructor(constructor);
                Constructor<T> constructor2 = constructor;
                return constructor2;
            }
            finally {
                this.constructorGuard.remove(hashCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Constructor<T> getConstructor(Class<?> ... paramTypes) throws NoSuchMethodException {
            Integer hashCode = Arrays.hashCode(paramTypes);
            if (this.constructorCache.containsKey(hashCode)) {
                return this.constructorCache.get(hashCode);
            }
            if (this.constructorGuard.contains(hashCode)) {
                while (this.constructorGuard.contains(hashCode)) {
                }
                return this.getConstructor(paramTypes);
            }
            this.constructorGuard.add(hashCode);
            try {
                Constructor<T> constructor = this.clazz.getConstructor(paramTypes);
                this.cacheConstructor(constructor);
                Constructor<T> constructor2 = constructor;
                return constructor2;
            }
            finally {
                this.constructorGuard.remove(hashCode);
            }
        }

        public void cacheMethod(Method method) {
            this.methodCache.computeIfAbsent(method.getName(), unused -> ConcurrentHashMap.newKeySet()).add(method);
        }

        public Method getDeclaredMethod(String name, Class<?> ... paramTypes) throws NoSuchMethodException {
            if (this.methodCache.containsKey(name)) {
                Collection<Method> methods = this.methodCache.get(name);
                for (Method method : methods) {
                    if (!Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                    return method;
                }
            }
            Method method = this.clazz.getDeclaredMethod(name, paramTypes);
            this.cacheMethod(method);
            return method;
        }

        public void cacheField(Field field) {
            this.fieldCache.put(field.getName(), field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Field getDeclaredField(String name) throws NoSuchFieldException {
            if (this.fieldCache.containsKey(name)) {
                return this.fieldCache.get(name);
            }
            if (this.fieldGuard.contains(name)) {
                while (this.fieldGuard.contains(name)) {
                }
                return this.getDeclaredField(name);
            }
            this.fieldGuard.add(name);
            try {
                Field field = this.clazz.getDeclaredField(name);
                this.cacheField(field);
                Field field2 = field;
                return field2;
            }
            finally {
                this.fieldGuard.remove(name);
            }
        }
    }
}

