/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import org.apache.commons.lang.WordUtils;
import org.mineacademy.fo.Common;

enum PotionWrapper {
    SLOW("SLOW", "Slowness"),
    STRENGTH("INCREASE_DAMAGE"),
    JUMP_BOOST("JUMP"),
    INSTANT_HEAL("INSTANT_HEALTH"),
    REGEN("REGENERATION");

    private final String bukkitName;
    private final String minecraftName;

    private PotionWrapper(String bukkitName) {
        this(bukkitName, null);
    }

    protected static String getLocalizedName(String name) {
        String localizedName = name;
        for (PotionWrapper e : PotionWrapper.values()) {
            if (!name.toUpperCase().replace(" ", "_").equals(e.bukkitName)) continue;
            localizedName = e.getMinecraftName();
            break;
        }
        return WordUtils.capitalizeFully((String)localizedName.replace("_", " "));
    }

    protected static String getBukkitName(String name) {
        name = name.toUpperCase().replace(" ", "_");
        for (PotionWrapper e : PotionWrapper.values()) {
            if (!e.toString().equalsIgnoreCase(name) && (e.minecraftName == null || !e.minecraftName.equalsIgnoreCase(name))) continue;
            return e.bukkitName;
        }
        return name;
    }

    public String getMinecraftName() {
        return Common.getOrDefault(this.minecraftName, this.bukkitName);
    }

    private PotionWrapper(String bukkitName, String minecraftName) {
        this.bukkitName = bukkitName;
        this.minecraftName = minecraftName;
    }
}

