/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.ItemUtil;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.jsonsimple.JSONObject;
import org.mineacademy.fo.jsonsimple.JSONParser;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.CompProperty;
import org.mineacademy.fo.remain.Remain;

public final class PlayerUtil {
    public static final int USABLE_PLAYER_INV_SIZE = 36;
    private static final Map<UUID, BukkitTask> titleRestoreTasks = new ConcurrentHashMap<UUID, BukkitTask>();

    public static void kick(Player player, String ... message) {
        Common.runLater(() -> player.kickPlayer(Common.colorize(message)));
    }

    public static int getPing(Player player) {
        Object entityPlayer = Remain.getHandleEntity((Entity)player);
        return (Integer)ReflectionUtil.getFieldContent(entityPlayer, "ping");
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic) {
        return PlayerUtil.getStatistics(statistic, null, null);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, Material material) {
        return PlayerUtil.getStatistics(statistic, material, null);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, EntityType entityType) {
        return PlayerUtil.getStatistics(statistic, null, entityType);
    }

    public static TreeMap<Long, OfflinePlayer> getStatistics(Statistic statistic, Material material, EntityType entityType) {
        TreeMap<Long, OfflinePlayer> statistics = new TreeMap<Long, OfflinePlayer>(Collections.reverseOrder());
        for (OfflinePlayer offline : Bukkit.getOfflinePlayers()) {
            long time = PlayerUtil.getStatistic(offline, statistic, material, entityType);
            statistics.put(time, offline);
        }
        return statistics;
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic) {
        return PlayerUtil.getStatistic(player, statistic, null, null);
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic, Material material) {
        return PlayerUtil.getStatistic(player, statistic, material, null);
    }

    public static long getStatistic(OfflinePlayer player, Statistic statistic, EntityType entityType) {
        return PlayerUtil.getStatistic(player, statistic, null, entityType);
    }

    private static long getStatistic(OfflinePlayer player, Statistic statistic, Material material, EntityType entityType) {
        if (player.isOnline()) {
            Player online = player.getPlayer();
            if (statistic.getType() == Statistic.Type.UNTYPED) {
                return online.getStatistic(statistic);
            }
            if (statistic.getType() == Statistic.Type.ENTITY) {
                return online.getStatistic(statistic, entityType);
            }
            return online.getStatistic(statistic, material);
        }
        return PlayerUtil.getStatisticFile(player, statistic, material, entityType);
    }

    private static long getStatisticFile(OfflinePlayer player, Statistic statistic, Material material, EntityType entityType) {
        File worldFolder = new File(((World)Bukkit.getServer().getWorlds().get(0)).getWorldFolder(), "stats");
        File statFile = new File(worldFolder, player.getUniqueId().toString() + ".json");
        if (statFile.exists()) {
            try {
                JSONObject json = (JSONObject)JSONParser.getInstance().parse(new FileReader(statFile));
                String name = Remain.getNMSStatisticName(statistic, material, entityType);
                JSONObject section = json.getObject("stats");
                long result = 0L;
                for (String part : name.split("\\:")) {
                    part = part.replace(".", ":");
                    if (section == null) continue;
                    JSONObject nextSection = section.getObject(part);
                    if (nextSection == null) {
                        result = Long.parseLong(section.containsKey(part) ? section.get(part).toString() : "0");
                        break;
                    }
                    section = nextSection;
                }
                return result;
            }
            catch (Throwable t) {
                throw new FoException(t);
            }
        }
        return 0L;
    }

    @Deprecated
    public static boolean hasPermUnsafe(UUID id, String permission) {
        return HookManager.hasPermissionUnsafe(id, permission.replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase()));
    }

    @Deprecated
    public static boolean hasPermUnsafe(String playerName, String permission) {
        return HookManager.hasPermissionUnsafe(playerName, permission.replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase()));
    }

    public static boolean hasPerm(@NonNull Permissible sender, @Nullable String permission) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        return permission == null || sender.hasPermission(!permission.contains("{plugin_name}") ? permission : permission.replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase()));
    }

    public static void normalize(Player player, boolean cleanInventory) {
        PlayerUtil.normalize(player, cleanInventory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void normalize(Player player, boolean cleanInventory, boolean removeVanish) {
        Map<UUID, BukkitTask> map = titleRestoreTasks;
        synchronized (map) {
            HookManager.setGodMode(player, false);
            player.setGameMode(GameMode.SURVIVAL);
            if (cleanInventory) {
                PlayerUtil.cleanInventoryAndFood(player);
                player.resetMaxHealth();
                player.setHealth(20.0);
                player.setHealthScaled(false);
                for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                    player.removePotionEffect(potionEffect.getType());
                }
            }
            player.setTotalExperience(0);
            player.setLevel(0);
            player.setExp(0.0f);
            player.resetPlayerTime();
            player.resetPlayerWeather();
            player.setFallDistance(0.0f);
            CompProperty.INVULNERABLE.apply(player, false);
            try {
                player.setGlowing(false);
                player.setSilent(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            player.setAllowFlight(false);
            player.setFlying(false);
            player.setFlySpeed(0.2f);
            player.setWalkSpeed(0.2f);
            player.setCanPickupItems(true);
            player.setVelocity(new Vector(0, 0, 0));
            player.eject();
            if (player.isInsideVehicle()) {
                player.getVehicle().remove();
            }
            try {
                for (Entity entity : player.getPassengers()) {
                    player.removePassenger(entity);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (removeVanish) {
                try {
                    if (player.hasMetadata("vanished")) {
                        Plugin plugin = ((MetadataValue)player.getMetadata("vanished").get(0)).getOwningPlugin();
                        player.removeMetadata("vanished", plugin);
                    }
                    for (Player player2 : Remain.getOnlinePlayers()) {
                        if (player2.getName().equals(player.getName()) || player2.canSee(player)) continue;
                        player2.showPlayer(player);
                    }
                }
                catch (NoSuchMethodError plugin) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static void cleanInventoryAndFood(Player player) {
        player.getInventory().setArmorContents(null);
        player.getInventory().setContents(new ItemStack[player.getInventory().getContents().length]);
        try {
            player.getInventory().setExtraContents(new ItemStack[player.getInventory().getExtraContents().length]);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        player.setFireTicks(0);
        player.setFoodLevel(20);
        player.setExhaustion(0.0f);
        player.setSaturation(10.0f);
        player.setVelocity(new Vector(0, 0, 0));
    }

    public static boolean hasEmptyInventory(Player player) {
        ItemStack[] everything;
        Object[] inv = player.getInventory().getContents();
        Object[] armor = player.getInventory().getArmorContents();
        for (ItemStack i : everything = (ItemStack[])ArrayUtils.addAll((Object[])inv, (Object[])armor)) {
            if (i == null || i.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static boolean isVanished(Player player, @Nullable Player otherPlayer) {
        if (otherPlayer != null && !otherPlayer.canSee(player)) {
            return true;
        }
        return PlayerUtil.isVanished(player);
    }

    public static boolean isVanished(Player player) {
        if (HookManager.isVanished(player)) {
            return true;
        }
        if (player.hasMetadata("vanished")) {
            for (MetadataValue meta : player.getMetadata("vanished")) {
                if (!meta.asBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    public static Player getPlayerByNickNoVanish(String name) {
        return PlayerUtil.getPlayerByNick(name, false);
    }

    public static Player getPlayerByNick(String name, boolean ignoreVanished) {
        Player found = Bukkit.getPlayer((String)name);
        if (found == null) {
            found = PlayerUtil.lookupNickedPlayer0(name);
        }
        if (ignoreVanished && found != null && PlayerUtil.isVanished(found)) {
            return null;
        }
        return found;
    }

    private static Player lookupNickedPlayer0(String name) {
        Player found = null;
        int delta = Integer.MAX_VALUE;
        for (Player player : Remain.getOnlinePlayers()) {
            String nick = HookManager.getNick((CommandSender)player);
            if (!nick.toLowerCase().startsWith(name)) continue;
            int curDelta = Math.abs(nick.length() - name.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    public static void updateInventoryTitle(Menu menu, Player player, String temporaryTitle, String oldTitle, int duration) {
        Valid.checkNotNull(menu, "Menu == null");
        Valid.checkNotNull(player, "Player == null");
        Valid.checkNotNull(temporaryTitle, "Title == null");
        Valid.checkNotNull(oldTitle, "Old Title == null");
        PlayerUtil.updateInventoryTitle(player, MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? temporaryTitle.replace("%", "%%") : temporaryTitle);
        BukkitTask pending = titleRestoreTasks.get(player.getUniqueId());
        if (pending != null) {
            pending.cancel();
        }
        pending = Common.runLater(duration, () -> {
            Menu futureMenu = Menu.getMenu(player);
            if (futureMenu != null && futureMenu.getClass().getName().equals(menu.getClass().getName())) {
                PlayerUtil.updateInventoryTitle(player, oldTitle);
            }
        });
        UUID uid = player.getUniqueId();
        titleRestoreTasks.put(uid, pending);
        Common.runLater(duration + 1, () -> {
            if (titleRestoreTasks.containsKey(uid)) {
                titleRestoreTasks.remove(uid);
            }
        });
    }

    public static void updateInventoryTitle(Player player, String title) {
        Remain.updateInventoryTitle(player, title);
    }

    public static ItemStack getFirstItem(Player player, ItemStack item) {
        for (ItemStack otherItem : player.getInventory().getContents()) {
            if (otherItem == null || !ItemUtil.isSimilar(otherItem, item)) continue;
            return otherItem;
        }
        return null;
    }

    public static boolean take(Player player, CompMaterial material, int amount) {
        if (!PlayerUtil.containsAtLeast(player, amount, material)) {
            return false;
        }
        for (int i = 0; i < amount; ++i) {
            PlayerUtil.takeFirstOnePiece(player, material);
        }
        return true;
    }

    public static boolean takeFirstOnePiece(Player player, CompMaterial material) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || CompMaterial.fromLegacy(item.getType().toString(), item.getData().getData()) != material) continue;
            PlayerUtil.takeOnePiece(player, item);
            return true;
        }
        return false;
    }

    public static void takeOnePiece(Player player, ItemStack item) {
        Remain.takeItemOnePiece(player, item);
    }

    public static boolean containsAtLeast(Player player, int atLeastSize, CompMaterial material) {
        int foundSize = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material.getMaterial()) continue;
            foundSize += item.getAmount();
        }
        return foundSize >= atLeastSize;
    }

    public static boolean updateInvSlot(Inventory inv, ItemStack search, ItemStack replaceWith) {
        Valid.checkNotNull(inv, "Inv = null");
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack slot = inv.getItem(i);
            if (slot == null || !ItemUtil.isSimilar(slot, search)) continue;
            inv.setItem(i, replaceWith);
            return true;
        }
        return false;
    }

    public static Map<Integer, ItemStack> addItems(Inventory inventory, ItemStack ... items) {
        return PlayerUtil.addItems(inventory, 0, items);
    }

    private static Map<Integer, ItemStack> addItems(Inventory inventory, int oversizedStacks, ItemStack ... items) {
        if (PlayerUtil.isCombinedInv(inventory)) {
            Inventory fakeInventory = PlayerUtil.makeTruncatedInv((PlayerInventory)inventory);
            Map<Integer, ItemStack> overflow = PlayerUtil.addItems(fakeInventory, oversizedStacks, items);
            for (int i = 0; i < fakeInventory.getContents().length; ++i) {
                inventory.setItem(i, fakeInventory.getContents()[i]);
            }
            return overflow;
        }
        HashMap<Integer, ItemStack> left = new HashMap<Integer, ItemStack>();
        ItemStack[] combined = new ItemStack[items.length];
        block1: for (ItemStack item : items) {
            if (item == null || item.getAmount() < 1) continue;
            for (int j = 0; j < combined.length; ++j) {
                if (combined[j] == null) {
                    combined[j] = item.clone();
                    continue block1;
                }
                if (!combined[j].isSimilar(item)) continue;
                combined[j].setAmount(combined[j].getAmount() + item.getAmount());
                continue block1;
            }
        }
        block3: for (int i = 0; i < combined.length; ++i) {
            ItemStack item = combined[i];
            if (item == null || item.getType() == Material.AIR) continue;
            while (true) {
                int partialAmount;
                int maxAmount;
                int firstPartial;
                if ((firstPartial = PlayerUtil.firstPartial(inventory, item, maxAmount = oversizedStacks > item.getType().getMaxStackSize() ? oversizedStacks : item.getType().getMaxStackSize())) == -1) {
                    int firstFree = inventory.firstEmpty();
                    if (firstFree == -1) {
                        left.put(i, item);
                        continue block3;
                    }
                    if (item.getAmount() > maxAmount) {
                        ItemStack stack = item.clone();
                        stack.setAmount(maxAmount);
                        inventory.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - maxAmount);
                        continue;
                    }
                    inventory.setItem(firstFree, item);
                    continue block3;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= maxAmount) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block3;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return left;
    }

    private static int firstPartial(Inventory inventory, ItemStack item, int maxAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] stacks = inventory.getContents();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack cItem = stacks[i];
            if (cItem == null || cItem.getAmount() >= maxAmount || !cItem.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    private static Inventory makeTruncatedInv(PlayerInventory playerInventory) {
        Inventory fake = Bukkit.createInventory(null, (int)36);
        fake.setContents(Arrays.copyOf(playerInventory.getContents(), fake.getSize()));
        return fake;
    }

    private static boolean isCombinedInv(Inventory inventory) {
        return inventory instanceof PlayerInventory && inventory.getContents().length > 36;
    }

    private PlayerUtil() {
    }
}

