/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import org.bukkit.Bukkit;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;

public final class MinecraftVersion {
    private static String serverVersion;
    private static V current;

    public static boolean equals(V version) {
        return MinecraftVersion.compareWith(version) == 0;
    }

    public static boolean olderThan(V version) {
        return MinecraftVersion.compareWith(version) < 0;
    }

    public static boolean newerThan(V version) {
        return MinecraftVersion.compareWith(version) > 0;
    }

    public static boolean atLeast(V version) {
        return MinecraftVersion.equals(version) || MinecraftVersion.newerThan(version);
    }

    private static int compareWith(V version) {
        try {
            return MinecraftVersion.getCurrent().ver - version.ver;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public static String getServerVersion() {
        return serverVersion.equals("craftbukkit") ? "" : serverVersion;
    }

    public static V getCurrent() {
        return current;
    }

    static {
        try {
            String packageName = Bukkit.getServer() == null ? "" : Bukkit.getServer().getClass().getPackage().getName();
            String curr = packageName.substring(packageName.lastIndexOf(46) + 1);
            boolean hasGatekeeper = !"craftbukkit".equals(curr);
            serverVersion = curr;
            if (hasGatekeeper) {
                int pos = 0;
                for (char ch : curr.toCharArray()) {
                    if (++pos > 2 && ch == 'R') break;
                }
                String numericVersion = curr.substring(1, pos - 2).replace("_", ".");
                int found = 0;
                for (char ch : numericVersion.toCharArray()) {
                    if (ch != '.') continue;
                    ++found;
                }
                Valid.checkBoolean(found == 1, "Minecraft Version checker malfunction. Could not detect your server version. Detected: " + numericVersion + " Current: " + curr, new Object[0]);
                current = V.parse(Integer.parseInt(numericVersion.split("\\.")[1]));
            } else {
                current = V.v1_3_AND_BELOW;
            }
        }
        catch (Throwable t) {
            Common.error(t, "Error detecting your Minecraft version. Check your server compatibility.");
        }
    }

    public static enum V {
        v1_17(17, false),
        v1_16(16),
        v1_15(15),
        v1_14(14),
        v1_13(13),
        v1_12(12),
        v1_11(11),
        v1_10(10),
        v1_9(9),
        v1_8(8),
        v1_7(7),
        v1_6(6),
        v1_5(5),
        v1_4(4),
        v1_3_AND_BELOW(3);

        private final int ver;
        private final boolean tested;

        private V(int version) {
            this(version, true);
        }

        private V(int version, boolean tested) {
            this.ver = version;
            this.tested = tested;
        }

        protected static V parse(int number) {
            for (V v : V.values()) {
                if (v.ver != number) continue;
                return v;
            }
            throw new FoException("Invalid version number: " + number);
        }

        public boolean isTested() {
            return this.tested;
        }
    }
}

