/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import org.bukkit.command.CommandSender;
import org.mineacademy.fo.Common;

public final class Messenger {
    private static String infoPrefix = "&8&l[&9&li&8&l] &7";
    private static String successPrefix = "&8&l[&2&l\u2714&8&l] &7";
    private static String warnPrefix = "&8&l[&6&l!&8&l] &6";
    private static String errorPrefix = "&8&l[&4&l\u2715&8&l] &c";
    private static String questionPrefix = "&8&l[&a&l?&l&8] &7";
    private static String announcePrefix = "&8&l[&5&l!&l&8] &d";

    public static void info(CommandSender player, String message) {
        Messenger.tell(player, infoPrefix, message);
    }

    public static void success(CommandSender player, String message) {
        Messenger.tell(player, successPrefix, message);
    }

    public static void warn(CommandSender player, String message) {
        Messenger.tell(player, warnPrefix, message);
    }

    public static void error(CommandSender player, String message) {
        Messenger.tell(player, errorPrefix, message);
    }

    public static void question(CommandSender player, String message) {
        Messenger.tell(player, questionPrefix, message);
    }

    public static void announce(CommandSender player, String message) {
        Messenger.tell(player, announcePrefix, message);
    }

    private static void tell(CommandSender player, String prefix, String message) {
        Common.tellNoPrefix(player, prefix + message);
    }

    private Messenger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setInfoPrefix(String infoPrefix) {
        Messenger.infoPrefix = infoPrefix;
    }

    public static void setSuccessPrefix(String successPrefix) {
        Messenger.successPrefix = successPrefix;
    }

    public static void setWarnPrefix(String warnPrefix) {
        Messenger.warnPrefix = warnPrefix;
    }

    public static void setErrorPrefix(String errorPrefix) {
        Messenger.errorPrefix = errorPrefix;
    }

    public static void setQuestionPrefix(String questionPrefix) {
        Messenger.questionPrefix = questionPrefix;
    }

    public static void setAnnouncePrefix(String announcePrefix) {
        Messenger.announcePrefix = announcePrefix;
    }
}

