/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import org.apache.commons.lang.WordUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.EnchantmentWrapper;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.PotionWrapper;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.nbt.NBTItem;

public final class ItemUtil {
    private static final boolean LEGACY_MATERIALS = MinecraftVersion.olderThan(MinecraftVersion.V.v1_13);

    public static PotionEffectType findPotion(String name) {
        name = PotionWrapper.getBukkitName(name);
        PotionEffectType potion = PotionEffectType.getByName((String)name);
        Valid.checkNotNull(potion, "Invalid potion '" + name + "'! For valid names, see: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/potion/PotionEffectType.html");
        return potion;
    }

    public static Enchantment findEnchantment(String name) {
        Enchantment enchant = Enchantment.getByName((String)name.toLowerCase());
        if (enchant == null) {
            enchant = Enchantment.getByName((String)name);
        }
        if (enchant == null && (enchant = Enchantment.getByName((String)(name = EnchantmentWrapper.toBukkit(name)).toLowerCase())) == null) {
            enchant = Enchantment.getByName((String)name);
        }
        Valid.checkNotNull(enchant, "Invalid enchantment '" + name + "'! For valid names, see: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/enchantments/Enchantment.html");
        return enchant;
    }

    public static String bountifyCapitalized(Enum<?> enumeration) {
        return WordUtils.capitalizeFully((String)ItemUtil.bountify(enumeration.toString().toLowerCase()));
    }

    public static String bountifyCapitalized(String name) {
        return WordUtils.capitalizeFully((String)ItemUtil.bountify(name));
    }

    public static String bountify(Enum<?> enumeration) {
        return ItemUtil.bountify(enumeration.toString());
    }

    public static String bountify(String name) {
        return name.toLowerCase().replace("_", " ");
    }

    public static String bountify(PotionEffectType enumeration) {
        return PotionWrapper.getLocalizedName(enumeration.getName());
    }

    public static String bountify(Enchantment enchant) {
        return EnchantmentWrapper.toMinecraft(enchant.getName());
    }

    public static boolean isSimilar(ItemStack first, ItemStack second) {
        String sName;
        boolean metaMatch;
        if (first == null || second == null) {
            return false;
        }
        boolean idMatch = first.getType() == second.getType();
        boolean dataMatch = !LEGACY_MATERIALS || first.getData().getData() == second.getData().getData();
        boolean bl = metaMatch = first.hasItemMeta() == second.hasItemMeta();
        if (!idMatch || !metaMatch || !dataMatch && !(dataMatch = first.getType() == Material.BOW)) {
            return false;
        }
        ItemMeta f = first.getItemMeta();
        ItemMeta s = second.getItemMeta();
        String fName = Common.stripColors(Common.getOrEmpty(f.getDisplayName()).toLowerCase());
        if (!fName.equals(sName = Common.stripColors(Common.getOrEmpty(s.getDisplayName()).toLowerCase())) || !Valid.listEquals(f.getLore(), s.getLore())) {
            return false;
        }
        NBTItem firstNbt = new NBTItem(first);
        NBTItem secondNbt = new NBTItem(second);
        return ItemUtil.matchNbt(SimplePlugin.getNamed(), firstNbt, secondNbt) && ItemUtil.matchNbt(SimplePlugin.getNamed() + "_Item", firstNbt, secondNbt);
    }

    private static boolean matchNbt(String key, NBTItem firstNbt, NBTItem secondNbt) {
        boolean firstHas = firstNbt.hasKey(key);
        boolean secondHas = secondNbt.hasKey(key);
        if (!firstHas && !secondHas) {
            return true;
        }
        if (firstHas && !secondHas || !firstHas && secondHas) {
            return false;
        }
        return firstNbt.getString(key).equals(secondNbt.getString(key));
    }

    private ItemUtil() {
    }
}

