/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.mineacademy.fo.EntityUtil;
import org.mineacademy.fo.collection.expiringmap.ExpiringMap;

class HitTracking
implements Listener {
    private static final ExpiringMap<UUID, EntityUtil.HitListener> flyingProjectiles = ExpiringMap.builder().expiration(30L, TimeUnit.SECONDS).build();

    HitTracking() {
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onHit(ProjectileHitEvent event) {
        EntityUtil.HitListener hitListener = flyingProjectiles.remove(event.getEntity().getUniqueId());
        if (hitListener != null) {
            hitListener.onHit(event);
        }
    }

    static void addFlyingProjectile(Projectile projectile, EntityUtil.HitListener hitTask) {
        flyingProjectiles.put(projectile.getUniqueId(), hitTask);
    }
}

