/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import org.mineacademy.fo.collection.StrictMap;

public final class GeoAPI {
    private static final StrictMap<String, GeoResponse> cache = new StrictMap();

    public static GeoResponse getCountry(InetSocketAddress ip) {
        GeoResponse response = new GeoResponse("", "", "", "");
        if (ip == null) {
            return response;
        }
        if (ip.getHostString().equals("127.0.0.1") || ip.getHostString().equals("0.0.0.0")) {
            return new GeoResponse("local", "-", "local", "-");
        }
        if (cache.contains(ip.toString()) || cache.containsValue(response)) {
            return cache.get(ip.toString());
        }
        try {
            URL url = new URL("http://ip-api.com/json/" + ip.getHostName());
            URLConnection con = url.openConnection();
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String input;
                String page = "";
                while ((input = r.readLine()) != null) {
                    page = page + input;
                }
                response = new GeoResponse(GeoAPI.getJson(page, "country"), GeoAPI.getJson(page, "countryCode"), GeoAPI.getJson(page, "regionName"), GeoAPI.getJson(page, "isp"));
                cache.put(ip.toString(), response);
            }
        }
        catch (NoRouteToHostException url) {
        }
        catch (SocketTimeoutException url) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    private static String getJson(String page, String element) {
        return page.contains("\"" + element + "\":\"") ? page.split("\"" + element + "\":\"")[1].split("\",")[0] : "";
    }

    private GeoAPI() {
    }

    public static final class GeoResponse {
        private final String countryName;
        private final String countryCode;
        private final String regionName;
        private final String isp;

        public GeoResponse(String countryName, String countryCode, String regionName, String isp) {
            this.countryName = countryName;
            this.countryCode = countryCode;
            this.regionName = regionName;
            this.isp = isp;
        }

        public String getCountryName() {
            return this.countryName;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public String getIsp() {
            return this.isp;
        }
    }
}

